"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.show = void 0;
const tslib_1 = require("tslib");
const project_graph_1 = require("../project-graph/project-graph");
function show(args) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        if (args.object == 'projects') {
            const graph = yield (0, project_graph_1.createProjectGraphAsync)();
            const projects = Object.keys(graph.nodes).join('\n');
            if (projects.length) {
                console.log(projects);
            }
        }
        else {
            throw new Error(`Unrecognized option: ${args.object}`);
        }
    });
}
exports.show = show;
//# sourceMappingURL=show.js.map