import type { NxJsonConfiguration, TargetDefaults } from './nx-json';
import { ProjectConfiguration, ProjectsConfigurations, TargetConfiguration } from './workspace-json-project-json';
import { ExecutorConfig, Generator, GeneratorsJsonEntry } from './misc-interfaces';
export declare class Workspaces {
    private root;
    private cachedProjectsConfig;
    constructor(root: string);
    relativeCwd(cwd: string): string;
    calculateDefaultProjectName(cwd: string, { projects }: ProjectsConfigurations, nxJson: NxJsonConfiguration): string;
    /**
     * @deprecated
     */
    readProjectsConfigurations(opts?: {
        _ignorePluginInference?: boolean;
        _includeProjectsFromAngularJson?: boolean;
    }): ProjectsConfigurations;
    /**
     * Deprecated. Use readProjectsConfigurations
     */
    readWorkspaceConfiguration(opts?: {
        _ignorePluginInference?: boolean;
        _includeProjectsFromAngularJson?: boolean;
    }): ProjectsConfigurations & NxJsonConfiguration;
    private mergeTargetDefaultsIntoProjectDescriptions;
    isNxExecutor(nodeModule: string, executor: string): boolean;
    isNxGenerator(collectionName: string, generatorName: string): boolean;
    readExecutor(nodeModule: string, executor: string): ExecutorConfig & {
        isNgCompat: boolean;
    };
    readGenerator(collectionName: string, generatorName: string): {
        resolvedCollectionName: string;
        normalizedGeneratorName: string;
        schema: any;
        implementationFactory: () => Generator<unknown>;
        isNgCompat: boolean;
        /**
         * @deprecated(v16): This will be removed in v16, use generatorConfiguration.aliases
         */
        aliases: string[];
        generatorConfiguration: GeneratorsJsonEntry;
    };
    hasNxJson(): boolean;
    readNxJson(): NxJsonConfiguration;
    private mergeTargetDefaultsAndTargetDependencies;
    private getImplementationFactory;
    private readExecutorsJson;
    private readGeneratorsJson;
    private resolvePaths;
}
/**
 * Pulled from toFileName in names from @nrwl/devkit.
 * Todo: Should refactor, not duplicate.
 */
export declare function toProjectName(fileName: string): string;
/**
 * @deprecated Use getGlobPatternsFromPluginsAsync instead.
 */
export declare function getGlobPatternsFromPlugins(nxJson: NxJsonConfiguration, paths: string[], root?: string): string[];
export declare function getGlobPatternsFromPluginsAsync(nxJson: NxJsonConfiguration, paths: string[], root?: string): Promise<string[]>;
/**
 * Get the package.json globs from package manager workspaces
 */
export declare function getGlobPatternsFromPackageManagerWorkspaces(root: string): string[];
export declare function globForProjectFiles(root: string, pluginsGlobPatterns: string[], nxJson?: NxJsonConfiguration): string[];
/**
 * @description Loops through files and reduces them to 1 file per project.
 * @param files Array of files that may represent projects
 */
export declare function deduplicateProjectFiles(files: string[]): string[];
export declare function inferProjectFromNonStandardFile(file: string): ProjectConfiguration & {
    name: string;
};
export declare function buildProjectsConfigurationsFromGlobs(nxJson: NxJsonConfiguration, projectFiles: string[], // making this parameter allows devkit to pick up newly created projects
readJson?: <T extends Object>(string: any) => T): ProjectsConfigurations;
export declare function mergeTargetConfigurations(projectConfiguration: ProjectConfiguration, target: string, targetDefaults: TargetDefaults[string]): TargetConfiguration;
export declare function readTargetDefaultsForTarget(targetName: string, targetDefaults: TargetDefaults, executor?: string): TargetDefaults[string];
export declare function renamePropertyWithStableKeys(obj: any, from: string, to: string): void;
