"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NativeFileHasher = void 0;
const tslib_1 = require("tslib");
const file_hasher_base_1 = require("./file-hasher-base");
const perf_hooks_1 = require("perf_hooks");
const app_root_1 = require("../utils/app-root");
class NativeFileHasher extends file_hasher_base_1.FileHasherBase {
    static available() {
        try {
            require('../native');
            return true;
        }
        catch (_a) {
            return false;
        }
    }
    init() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            perf_hooks_1.performance.mark('init hashing:start');
            // Import as needed. There is also an issue running unit tests in Nx repo if this is a top-level import.
            const { hashFiles } = require('../native');
            this.clear();
            const filesObject = hashFiles(app_root_1.workspaceRoot);
            this.fileHashes = new Map(Object.entries(filesObject));
            perf_hooks_1.performance.mark('init hashing:end');
            perf_hooks_1.performance.measure('init hashing', 'init hashing:start', 'init hashing:end');
        });
    }
    hashFiles(files) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const r = new Map();
            for (let f of files) {
                r.set(f, this.hashFile(f));
            }
            return r;
        });
    }
    hashFile(path) {
        // Import as needed. There is also an issue running unit tests in Nx repo if this is a top-level import.
        const { hashFile } = require('../native');
        return hashFile(path).hash;
    }
}
exports.NativeFileHasher = NativeFileHasher;
//# sourceMappingURL=native-file-hasher.js.map