"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const nx_json_1 = require("../../generators/utils/nx-json");
const format_changed_files_with_prettier_if_available_1 = require("../../generators/internal-utils/format-changed-files-with-prettier-if-available");
function default_1(tree) {
    var _a;
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        // If the workspace doesn't have a nx.json, don't make any changes
        if (!tree.exists('nx.json')) {
            return;
        }
        const nxJson = (0, nx_json_1.readNxJson)(tree);
        (_a = nxJson.cli) === null || _a === void 0 ? true : delete _a.defaultCollection;
        if (nxJson.cli && Object.keys(nxJson.cli).length === 0) {
            delete nxJson.cli;
        }
        (0, nx_json_1.updateNxJson)(tree, nxJson);
        yield (0, format_changed_files_with_prettier_if_available_1.formatChangedFilesWithPrettierIfAvailable)(tree);
    });
}
exports.default = default_1;
//# sourceMappingURL=remove-default-collection.js.map