"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const format_changed_files_with_prettier_if_available_1 = require("../../generators/internal-utils/format-changed-files-with-prettier-if-available");
const nx_json_1 = require("../../generators/utils/nx-json");
function default_1(tree) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        // If the workspace doesn't have a nx.json, don't make any changes
        if (!tree.exists('nx.json')) {
            return;
        }
        const nxJson = (0, nx_json_1.readNxJson)(tree);
        if (nxJson.targetDependencies) {
            nxJson.targetDefaults = {};
            for (const targetName of Object.keys(nxJson.targetDependencies)) {
                const dependsOn = [];
                for (const c of nxJson.targetDependencies[targetName]) {
                    if (typeof c === 'string') {
                        dependsOn.push(c);
                    }
                    else if (c.projects === 'self') {
                        dependsOn.push(c.target);
                    }
                    else {
                        dependsOn.push(`^${c.target}`);
                    }
                }
                nxJson.targetDefaults[targetName] = {
                    dependsOn,
                };
            }
        }
        delete nxJson.targetDependencies;
        (0, nx_json_1.updateNxJson)(tree, nxJson);
        yield (0, format_changed_files_with_prettier_if_available_1.formatChangedFilesWithPrettierIfAvailable)(tree);
    });
}
exports.default = default_1;
//# sourceMappingURL=create-target-defaults.js.map