"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addVsCodeRecommendedExtensions = exports.initCloud = exports.runInstall = exports.addDepsToPackageJson = exports.createNxJsonFile = exports.askAboutNxCloud = void 0;
const child_process_1 = require("child_process");
const enquirer = require("enquirer");
const path_1 = require("path");
const fileutils_1 = require("../utils/fileutils");
const package_manager_1 = require("../utils/package-manager");
const child_process_2 = require("../utils/child-process");
const path_2 = require("../utils/path");
function askAboutNxCloud() {
    return enquirer
        .prompt([
        {
            name: 'NxCloud',
            message: `Enable distributed caching to make your CI faster`,
            type: 'autocomplete',
            choices: [
                {
                    name: 'Yes',
                    hint: 'I want faster builds',
                },
                {
                    name: 'No',
                },
            ],
            initial: 'Yes',
        },
    ])
        .then((a) => a.NxCloud === 'Yes');
}
exports.askAboutNxCloud = askAboutNxCloud;
function createNxJsonFile(repoRoot, targetDefaults, cacheableOperations, scriptOutputs) {
    var _a, _b, _c, _d, _e;
    const nxJsonPath = (0, path_2.joinPathFragments)(repoRoot, 'nx.json');
    let nxJson = {};
    try {
        nxJson = (0, fileutils_1.readJsonFile)(nxJsonPath);
        // eslint-disable-next-line no-empty
    }
    catch (_f) { }
    nxJson.tasksRunnerOptions || (nxJson.tasksRunnerOptions = {});
    (_a = nxJson.tasksRunnerOptions).default || (_a.default = {});
    (_b = nxJson.tasksRunnerOptions.default).runner || (_b.runner = 'nx/tasks-runners/default');
    (_c = nxJson.tasksRunnerOptions.default).options || (_c.options = {});
    nxJson.tasksRunnerOptions.default.options.cacheableOperations =
        cacheableOperations;
    if (targetDefaults.length > 0) {
        nxJson.targetDefaults || (nxJson.targetDefaults = {});
        for (const scriptName of targetDefaults) {
            (_d = nxJson.targetDefaults)[scriptName] || (_d[scriptName] = {});
            nxJson.targetDefaults[scriptName] = { dependsOn: [`^${scriptName}`] };
        }
        for (const [scriptName, output] of Object.entries(scriptOutputs)) {
            if (!output) {
                // eslint-disable-next-line no-continue
                continue;
            }
            (_e = nxJson.targetDefaults)[scriptName] || (_e[scriptName] = {});
            nxJson.targetDefaults[scriptName].outputs = [`{projectRoot}/${output}`];
        }
    }
    nxJson.defaultBase = deduceDefaultBase();
    (0, fileutils_1.writeJsonFile)(nxJsonPath, nxJson);
}
exports.createNxJsonFile = createNxJsonFile;
function deduceDefaultBase() {
    try {
        (0, child_process_1.execSync)(`git rev-parse --verify main`, {
            stdio: ['ignore', 'ignore', 'ignore'],
        });
        return 'main';
    }
    catch (_a) {
        try {
            (0, child_process_1.execSync)(`git rev-parse --verify dev`, {
                stdio: ['ignore', 'ignore', 'ignore'],
            });
            return 'dev';
        }
        catch (_b) {
            try {
                (0, child_process_1.execSync)(`git rev-parse --verify develop`, {
                    stdio: ['ignore', 'ignore', 'ignore'],
                });
                return 'develop';
            }
            catch (_c) {
                try {
                    (0, child_process_1.execSync)(`git rev-parse --verify next`, {
                        stdio: ['ignore', 'ignore', 'ignore'],
                    });
                    return 'next';
                }
                catch (_d) {
                    return 'master';
                }
            }
        }
    }
}
function addDepsToPackageJson(repoRoot, useCloud) {
    const path = (0, path_2.joinPathFragments)(repoRoot, `package.json`);
    const json = (0, fileutils_1.readJsonFile)(path);
    if (!json.devDependencies)
        json.devDependencies = {};
    json.devDependencies['nx'] = require('../../package.json').version;
    if (useCloud) {
        json.devDependencies['@nrwl/nx-cloud'] = 'latest';
    }
    (0, fileutils_1.writeJsonFile)(path, json);
}
exports.addDepsToPackageJson = addDepsToPackageJson;
function runInstall(repoRoot, pmc = (0, package_manager_1.getPackageManagerCommand)()) {
    (0, child_process_1.execSync)(pmc.install, { stdio: [0, 1, 2], cwd: repoRoot });
}
exports.runInstall = runInstall;
function initCloud(repoRoot, installationSource) {
    (0, child_process_2.runNxSync)(`g @nrwl/nx-cloud:init --installationSource=${installationSource}`, {
        stdio: [0, 1, 2],
        cwd: repoRoot,
    });
}
exports.initCloud = initCloud;
function addVsCodeRecommendedExtensions(repoRoot, extensions) {
    var _a;
    const vsCodeExtensionsPath = (0, path_1.join)(repoRoot, '.vscode/extensions.json');
    if ((0, fileutils_1.fileExists)(vsCodeExtensionsPath)) {
        const vsCodeExtensionsJson = (0, fileutils_1.readJsonFile)(vsCodeExtensionsPath);
        (_a = vsCodeExtensionsJson.recommendations) !== null && _a !== void 0 ? _a : (vsCodeExtensionsJson.recommendations = []);
        extensions.forEach((extension) => {
            if (!vsCodeExtensionsJson.recommendations.includes(extension)) {
                vsCodeExtensionsJson.recommendations.push(extension);
            }
        });
        (0, fileutils_1.writeJsonFile)(vsCodeExtensionsPath, vsCodeExtensionsJson);
    }
    else {
        (0, fileutils_1.writeJsonFile)(vsCodeExtensionsPath, { recommendations: extensions });
    }
}
exports.addVsCodeRecommendedExtensions = addVsCodeRecommendedExtensions;
//# sourceMappingURL=utils.js.map