/**
 * This is the main API for accessing the lock file functionality.
 * It encapsulates the package manager specific logic and implementation details.
 */
import { PackageManager } from '../../../utils/package-manager';
import { ProjectGraph } from '../../../config/project-graph';
import { ProjectGraphBuilder } from '../../../project-graph/project-graph-builder';
import { PackageJson } from '../../../utils/package-json';
/**
 * Check if lock file exists
 */
export declare function lockFileExists(packageManager?: PackageManager): boolean;
/**
 * Hashes lock file content
 */
export declare function lockFileHash(packageManager?: PackageManager): string;
/**
 * Parses lock file and maps dependencies and metadata to {@link LockFileGraph}
 */
export declare function parseLockFile(builder: ProjectGraphBuilder, packageManager?: PackageManager): ProjectGraph;
/**
 * Returns lock file name based on the detected package manager in the root
 * @param packageManager
 * @returns
 */
export declare function getLockFileName(packageManager?: PackageManager): string;
/**
 * Create lock file based on the root level lock file and (pruned) package.json
 *
 * @param packageJson
 * @param isProduction
 * @param packageManager
 * @returns
 */
export declare function createLockFile(packageJson: PackageJson, packageManager?: PackageManager): string;
