"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractGlobalFilesFromInputs = exports.getImplicitlyTouchedProjects = exports.getTouchedProjects = void 0;
const minimatch = require("minimatch");
const find_project_for_path_1 = require("../../utils/find-project-for-path");
const getTouchedProjects = (touchedFiles, projectGraphNodes) => {
    const projectRootMap = (0, find_project_for_path_1.createProjectRootMappings)(projectGraphNodes);
    return touchedFiles.reduce((affected, f) => {
        const matchingProject = (0, find_project_for_path_1.findProjectForPath)(f.file, projectRootMap);
        if (matchingProject) {
            affected.push(matchingProject);
        }
        return affected;
    }, []);
};
exports.getTouchedProjects = getTouchedProjects;
const getImplicitlyTouchedProjects = (fileChanges, projectGraphNodes, nxJson) => {
    const implicits = Object.assign({}, nxJson.implicitDependencies);
    const globalFiles = [
        ...extractGlobalFilesFromInputs(nxJson),
        'nx.json',
        'package-lock.json',
        'yarn.lock',
        'pnpm-lock.yaml',
        'pnpm-lock.yml',
    ];
    globalFiles.forEach((file) => {
        implicits[file] = '*';
    });
    Object.values(projectGraphNodes || {}).forEach((node) => {
        [
            ...extractFilesFromNamedInputs(node.data.namedInputs),
            ...extractFilesFromTargetInputs(node.data.targets),
        ].forEach((input) => {
            var _a;
            (_a = implicits[input]) !== null && _a !== void 0 ? _a : (implicits[input] = []);
            if (Array.isArray(implicits[input])) {
                implicits[input].push(node.name);
            }
        });
    });
    const touched = new Set();
    for (const [pattern, projects] of Object.entries(implicits)) {
        const implicitDependencyWasChanged = fileChanges.some((f) => minimatch(f.file, pattern));
        if (!implicitDependencyWasChanged) {
            continue;
        }
        // File change affects all projects, just return all projects.
        if (projects === '*') {
            return Object.keys(projectGraphNodes);
        }
        else if (Array.isArray(projects)) {
            projects.forEach((project) => touched.add(project));
        }
    }
    return Array.from(touched);
};
exports.getImplicitlyTouchedProjects = getImplicitlyTouchedProjects;
function extractGlobalFilesFromInputs(nxJson) {
    const globalFiles = [];
    globalFiles.push(...extractFilesFromNamedInputs(nxJson.namedInputs));
    globalFiles.push(...extractFilesFromTargetInputs(nxJson.targetDefaults));
    return globalFiles;
}
exports.extractGlobalFilesFromInputs = extractGlobalFilesFromInputs;
function extractFilesFromNamedInputs(namedInputs) {
    const files = [];
    for (const inputs of Object.values(namedInputs || {})) {
        files.push(...extractFilesFromInputs(inputs));
    }
    return files;
}
function extractFilesFromTargetInputs(targets) {
    const globalFiles = [];
    for (const target of Object.values(targets || {})) {
        if (target.inputs) {
            globalFiles.push(...extractFilesFromInputs(target.inputs));
        }
    }
    return globalFiles;
}
function extractFilesFromInputs(inputs) {
    const globalFiles = [];
    for (const input of inputs) {
        if (typeof input === 'string' && input.startsWith('{workspaceRoot}/')) {
            globalFiles.push(input.substring('{workspaceRoot}/'.length));
        }
        else if (input.fileset && input.fileset.startsWith('{workspaceRoot}/')) {
            globalFiles.push(input.fileset.substring('{workspaceRoot}/'.length));
        }
    }
    return globalFiles;
}
//# sourceMappingURL=workspace-projects.js.map