"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.runNxSync = void 0;
const child_process_1 = require("child_process");
const fs_1 = require("fs");
const path_1 = require("path");
const package_manager_1 = require("./package-manager");
const workspace_root_1 = require("./workspace-root");
function runNxSync(cmd, options) {
    var _a;
    let baseCmd;
    if ((0, fs_1.existsSync)((0, path_1.join)(workspace_root_1.workspaceRoot, 'package.json'))) {
        baseCmd = `${(0, package_manager_1.getPackageManagerCommand)().exec} nx`;
    }
    else {
        options !== null && options !== void 0 ? options : (options = {});
        (_a = options.cwd) !== null && _a !== void 0 ? _a : (options.cwd = process.cwd());
        const offsetFromRoot = (0, path_1.relative)(options.cwd, (0, workspace_root_1.workspaceRootInner)(options.cwd, null));
        if (process.platform === 'win32') {
            baseCmd = '.\\' + (0, path_1.join)(`${offsetFromRoot}`, 'nx.bat');
        }
        else {
            baseCmd = './' + (0, path_1.join)(`${offsetFromRoot}`, 'nx');
        }
    }
    (0, child_process_1.execSync)(`${baseCmd} ${cmd}`, options);
}
exports.runNxSync = runNxSync;
//# sourceMappingURL=child-process.js.map