"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.listLocalWorkspacePlugins = exports.getLocalWorkspacePlugins = void 0;
const tslib_1 = require("tslib");
const chalk = require("chalk");
const output_1 = require("../output");
const shared_1 = require("./shared");
const fileutils_1 = require("../fileutils");
const path_1 = require("path");
const workspace_root_1 = require("../workspace-root");
const fs_1 = require("fs");
const plugin_capabilities_1 = require("./plugin-capabilities");
function getLocalWorkspacePlugins(projectsConfiguration) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const plugins = new Map();
        for (const project of Object.values(projectsConfiguration.projects)) {
            const packageJsonPath = (0, path_1.join)(workspace_root_1.workspaceRoot, project.root, 'package.json');
            if ((0, fs_1.existsSync)(packageJsonPath)) {
                const packageJson = (0, fileutils_1.readJsonFile)(packageJsonPath);
                const capabilities = yield (0, plugin_capabilities_1.getPluginCapabilities)(workspace_root_1.workspaceRoot, packageJson.name);
                if (capabilities &&
                    (capabilities.executors ||
                        capabilities.generators ||
                        capabilities.projectGraphExtension ||
                        capabilities.projectInference)) {
                    plugins.set(packageJson.name, Object.assign(Object.assign({}, capabilities), { name: packageJson.name }));
                }
            }
        }
        return plugins;
    });
}
exports.getLocalWorkspacePlugins = getLocalWorkspacePlugins;
function listLocalWorkspacePlugins(installedPlugins) {
    const bodyLines = [];
    for (const [, p] of installedPlugins) {
        const capabilities = [];
        if ((0, shared_1.hasElements)(p.executors)) {
            capabilities.push('executors');
        }
        if ((0, shared_1.hasElements)(p.generators)) {
            capabilities.push('generators');
        }
        bodyLines.push(`${chalk.bold(p.name)} (${capabilities.join()})`);
    }
    output_1.output.log({
        title: `Local workspace plugins:`,
        bodyLines: bodyLines,
    });
}
exports.listLocalWorkspacePlugins = listLocalWorkspacePlugins;
//# sourceMappingURL=local-plugins.js.map