"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.splitTarget = void 0;
function splitTarget(s, projectGraph) {
    var _a, _b, _c;
    let [project, ...segments] = splitByColons(s);
    const validTargets = (_c = (_b = (_a = projectGraph === null || projectGraph === void 0 ? void 0 : projectGraph.nodes) === null || _a === void 0 ? void 0 : _a[project]) === null || _b === void 0 ? void 0 : _b.data) === null || _c === void 0 ? void 0 : _c.targets;
    const validTargetNames = new Set(Object.keys(validTargets !== null && validTargets !== void 0 ? validTargets : {}));
    return [project, ...groupJointSegments(segments, validTargetNames)];
}
exports.splitTarget = splitTarget;
function groupJointSegments(segments, validTargetNames) {
    for (let endingSegmentIdx = segments.length; endingSegmentIdx > 0; endingSegmentIdx--) {
        const potentialTargetName = segments.slice(0, endingSegmentIdx).join(':');
        if (validTargetNames.has(potentialTargetName)) {
            const configurationName = endingSegmentIdx < segments.length
                ? segments.slice(endingSegmentIdx).join(':')
                : null;
            return configurationName
                ? [potentialTargetName, configurationName]
                : [potentialTargetName];
        }
    }
    // If we can't find a segment match, keep older behaviour
    return segments;
}
function splitByColons(s) {
    const parts = [];
    let currentPart = '';
    for (let i = 0; i < s.length; ++i) {
        if (s[i] === ':') {
            parts.push(currentPart);
            currentPart = '';
        }
        else if (s[i] === '"') {
            i++;
            for (; i < s.length && s[i] != '"'; ++i) {
                currentPart += s[i];
            }
        }
        else {
            currentPart += s[i];
        }
    }
    parts.push(currentPart);
    return parts;
}
//# sourceMappingURL=split-target.js.map