type NestedFiles = {
    [fileName: string]: string;
};
export declare class TempFs {
    private dirname;
    readonly tempDir: string;
    constructor(dirname: string, overrideWorkspaceRoot?: boolean);
    createFiles(fileObject: NestedFiles): Promise<void>;
    createFile(filePath: string, content: string): Promise<void>;
    readFile(filePath: string): Promise<string>;
    appendFile(filePath: string, content: string): void;
    writeFile(filePath: string, content: string): void;
    cleanup(): void;
    reset(): void;
}
export {};
