"use strict";
/**
 * A TypeScript port of a subset of is.js (https://github.com/arasatasaygin/is.js)
 * See https://github.com/arasatasaygin/is.js/blob/56294950656ba58f940248510cdf3e45af357a1e/is.js
 * MIT license https://github.com/arasatasaygin/is.js/blob/master/LICENSE
 */
Object.defineProperty(exports, "__esModule", { value: true });
const userAgent = ((typeof navigator === "object" && navigator.userAgent) ||
    "").toLowerCase();
const vendor = ((typeof navigator === "object" && navigator.vendor) ||
    "").toLowerCase();
exports.is = {
    chrome: () => {
        const match = /google inc/.test(vendor)
            ? userAgent.match(/(?:chrome|crios)\/(\d+)/)
            : null;
        return match !== null && !exports.is.opera();
    },
    opera: () => {
        const match = userAgent.match(/(?:^opera.+?version|opr)\/(\d+)/);
        return match !== null;
    },
};
