"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const oaf_side_effects_1 = require("oaf-side-effects");
const _1 = require(".");
const createPageStateMemoryWithFallback = (settings) => {
    const dummyPageStateMemory = {
        pageState: () => undefined,
        update: () => { },
    };
    if (!settings.restorePageStateOnPop) {
        return dummyPageStateMemory;
    }
    try {
        return _1.createPageStateMemory();
    }
    catch (e) {
        // tslint:disable-next-line: no-console
        console.error(e);
        return dummyPageStateMemory;
    }
};
const documentTitle = (location, settings) => {
    const title = settings.documentTitle(location);
    if (title === null ||
        title === undefined ||
        typeof title !== "string" ||
        title.trim() === "") {
        // tslint:disable-next-line: no-console
        console.error(`Title [${title}] is invalid. See https://www.w3.org/TR/UNDERSTANDING-WCAG20/navigation-mechanisms-title.html`);
        return undefined;
    }
    else {
        return title;
    }
};
exports.createOafRouter = (settings, hashFromLocation) => {
    const resetAutoScrollRestoration = settings.disableAutoScrollRestoration
        ? _1.disableAutoScrollRestoration()
        : () => { };
    // HACK we need a way to track where focus and scroll were left on the first loaded page
    // but we won't have an entry in history for this initial page, so we just make up a key.
    const orInitialKey = (key) => key !== undefined ? key : "initial";
    const pageStateMemory = createPageStateMemoryWithFallback(settings);
    return {
        handleFirstPageLoad: (location) => __awaiter(this, void 0, void 0, function* () {
            const title = documentTitle(location, settings);
            if (settings.setPageTitle && title) {
                oaf_side_effects_1.setTitle(title);
            }
            if (settings.handleHashFragment) {
                const focusTarget = oaf_side_effects_1.elementFromHash(hashFromLocation(location));
                if (focusTarget !== undefined) {
                    oaf_side_effects_1.focusAndScrollIntoViewIfRequired(focusTarget, focusTarget, settings.smoothScroll);
                }
            }
        }),
        handleLocationChanged: (previousLocation, currentLocation, currentLocationKey, action) => __awaiter(this, void 0, void 0, function* () {
            const title = documentTitle(currentLocation, settings);
            if (settings.setPageTitle && title) {
                oaf_side_effects_1.setTitle(title);
            }
            const shouldHandleAction = settings.shouldHandleAction(previousLocation, currentLocation, action);
            if (!shouldHandleAction) {
                return Promise.resolve();
            }
            if (settings.announcePageNavigation) {
                oaf_side_effects_1.announce(settings.navigationMessage(title || settings.documentTitleAnnounceFallback, currentLocation, action), settings.announcementsDivId, settings.setMessageTimeout, settings.clearMessageTimeout);
            }
            const primaryFocusTarget = typeof settings.primaryFocusTarget === "string"
                ? settings.primaryFocusTarget
                : settings.primaryFocusTarget(currentLocation);
            const shouldRestorePageState = action === "POP" && settings.restorePageStateOnPop;
            if (shouldRestorePageState) {
                const previousPageState = pageStateMemory.pageState(orInitialKey(currentLocationKey));
                const pageStateToSet = Object.assign({}, settings.defaultPageState, previousPageState);
                return _1.setPageState(pageStateToSet, primaryFocusTarget);
            }
            else {
                const focusTarget = settings.handleHashFragment
                    ? oaf_side_effects_1.elementFromHash(hashFromLocation(currentLocation))
                    : undefined;
                // TODO: warn if resetFocus returns false?
                yield oaf_side_effects_1.resetFocus(primaryFocusTarget, focusTarget, settings.smoothScroll);
                return;
            }
        }),
        handleLocationWillChange: (currentLocationKey, nextLocationKey, action) => {
            if (settings.restorePageStateOnPop) {
                pageStateMemory.update(action, orInitialKey(currentLocationKey), orInitialKey(nextLocationKey), _1.getPageState());
            }
        },
        resetAutoScrollRestoration,
    };
};
