"use strict";
// tslint:disable: no-expression-statement
// tslint:disable: no-if-statement
// tslint:disable: interface-over-type-literal
// tslint:disable: object-literal-sort-keys
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPageStateMemory = () => {
    // TODO constrain the size of these collections?
    // TODO persist these?
    const locations = new Array();
    const pageStateMap = new Map();
    const handlePushAction = (previousLocationKey, nextLocationKey) => {
        const desiredLocationsLength = locations.indexOf(previousLocationKey) + 1;
        while (locations.length > desiredLocationsLength) {
            const key = locations.pop();
            if (key !== undefined) {
                pageStateMap.delete(key);
            }
        }
        locations.push(nextLocationKey);
        return;
    };
    const handleReplaceAction = (previousLocationKey, nextLocationKey) => {
        const indexToReplace = locations.indexOf(previousLocationKey);
        if (indexToReplace !== -1) {
            // tslint:disable-next-line: no-object-mutation
            locations[indexToReplace] = nextLocationKey;
        }
        pageStateMap.delete(previousLocationKey);
    };
    return {
        pageState: (key) => {
            return pageStateMap.get(key);
        },
        update: (action, previousLocationKey, nextLocationKey, previousPageState) => {
            pageStateMap.set(previousLocationKey, previousPageState);
            if (action === "PUSH") {
                handlePushAction(previousLocationKey, nextLocationKey);
            }
            else if (action === "REPLACE") {
                handleReplaceAction(previousLocationKey, nextLocationKey);
            }
        },
    };
};
