import { ScrollPosition } from "oaf-side-effects";
import { Selector } from "unique-selector";
/**
 * Aspects of page state that should be restored after POP history
 * actions (i.e. after the user navigates back or forward in their browser).
 */
export declare type PageState = ScrollPosition & {
    /**
     * A CSS selector that uniquely specifies the element that has keyboard focus (if any).
     */
    readonly focusSelector?: Selector;
};
/**
 * Get the current page state.
 */
export declare const getPageState: () => PageState;
/**
 * Set the page state.
 * @param pageState the page state to set
 * @param primaryFocusTarget a CSS selector for your primary focus target, e.g. `[main h1]`
 */
export declare const setPageState: (pageState: PageState, primaryFocusTarget: string) => Promise<void>;
