"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const oaf_side_effects_1 = require("oaf-side-effects");
const unique_selector_1 = __importDefault(require("unique-selector"));
const is_1 = require("./is");
/**
 * Get the current page state.
 */
exports.getPageState = () => {
    const focusSelector = document.activeElement !== null
        ? unique_selector_1.default(document.activeElement)
        : undefined;
    return Object.assign({}, oaf_side_effects_1.getScrollPosition(), { focusSelector });
};
// Chrome doesn't restore the previously focused element when
// navigating back and forward (history POP), but Safari and Firefox do.
// TODO test more browsers here (Chromium, Opera, etc).
const shouldRestoreFocusAfterPop = !is_1.is.chrome();
/**
 * Set the page state.
 * @param pageState the page state to set
 * @param primaryFocusTarget a CSS selector for your primary focus target, e.g. `[main h1]`
 */
exports.setPageState = (pageState, primaryFocusTarget) => __awaiter(this, void 0, void 0, function* () {
    const previouslyFocusedElement = shouldRestoreFocusAfterPop && pageState.focusSelector !== undefined
        ? oaf_side_effects_1.elementFromTarget(pageState.focusSelector)
        : undefined;
    const elementToFocus = previouslyFocusedElement ||
        oaf_side_effects_1.elementFromTarget(primaryFocusTarget) ||
        document.body;
    yield oaf_side_effects_1.focusElement(elementToFocus, true);
    oaf_side_effects_1.setScrollPosition(pageState);
});
