import { Selector } from "oaf-side-effects";
import { Action, PageState } from ".";
export interface RouterSettings<Location> {
    readonly announcementsDivId: string;
    readonly primaryFocusTarget: Selector | ((location: Location) => Selector);
    readonly documentTitle: (location: Location) => string;
    readonly documentTitleAnnounceFallback: string;
    readonly navigationMessage: (title: string, location: Location, action?: Action) => string;
    readonly shouldHandleAction: (previousLocation: Location, nextLocation: Location, action?: Action) => boolean;
    readonly disableAutoScrollRestoration: boolean;
    readonly announcePageNavigation: boolean;
    readonly setPageTitle: boolean;
    readonly handleHashFragment: boolean;
    readonly restorePageStateOnPop: boolean;
    readonly renderTimeout: number;
    readonly defaultPageState: PageState;
    readonly smoothScroll?: boolean;
    readonly setMessageTimeout?: number;
    readonly clearMessageTimeout?: number;
}
export declare const defaultSettings: RouterSettings<unknown>;
