"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPkce = void 0;
function getPkce(length, callback) {
    if (!length)
        length = 44;
    var cryptoLib = msCrypto || crypto;
    var randomNumbers = cryptoLib.getRandomValues(new Uint8Array(length / 2));
    var verifier = '';
    for (var i = 0; i < randomNumbers.length; i++) {
        verifier += ('0' + randomNumbers[i].toString(16)).substr(-2);
    }
    var digest = cryptoLib.subtle.digest('SHA-256', randomNumbers);
    if (CryptoOperation) {
        digest.onerror = callback;
        digest.oncomplete = function (event) {
            callback(null, {
                verifier: verifier,
                challenge: btoa(String.fromCharCode.apply(null, new Uint8Array(event.target.result)))
            });
        };
    }
    else {
        digest
            .then(function (digest) {
            callback(null, {
                verifier: verifier,
                challenge: btoa(String.fromCharCode.apply(null, new Uint8Array(digest)))
            });
        })
            .catch(callback);
    }
}
exports.getPkce = getPkce;
