"use strict";
function b64Uri(string) {
    return btoa(string).replace(/\+/g, '-').replace(/\//g, '_').replace(/=+$/, '');
}
function getPkce(length, callback) {
    if (!length)
        length = 43;
    var cryptoLib = window.msCrypto || window.crypto;
    var verifier = b64Uri(Array.prototype.map
        .call(cryptoLib.getRandomValues(new Uint8Array(length)), function (number) {
        return String.fromCharCode(number);
    })
        .join('')).substring(0, length);
    var randomArray = new Uint8Array(verifier.length);
    for (var i = 0; i < verifier.length; i++) {
        randomArray[i] = verifier.charCodeAt(i);
    }
    var digest = cryptoLib.subtle.digest('SHA-256', randomArray);
    if (window.CryptoOperation) {
        digest.onerror = callback;
        digest.oncomplete = function (event) {
            runCallback(callback, verifier, event.target.result);
        };
    }
    else {
        digest
            .then(function (digest) {
            runCallback(callback, verifier, digest);
        })
            .catch(callback);
    }
}
function runCallback(callback, verifier, digest) {
    callback(null, {
        verifier: verifier,
        challenge: b64Uri(String.fromCharCode.apply(null, new Uint8Array(digest)))
    });
}
