'use strict';

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _recursiveGet = require('recursive-get');

var _recursiveGet2 = _interopRequireDefault(_recursiveGet);

var _isobject = require('isobject');

var _isobject2 = _interopRequireDefault(_isobject);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var ObjectFormatter = (function () {
	function ObjectFormatter() {
		var accessorSymbol = arguments.length <= 0 || arguments[0] === undefined ? '@' : arguments[0];
		var defaultValue = arguments.length <= 1 || arguments[1] === undefined ? void 0 : arguments[1];

		_classCallCheck(this, ObjectFormatter);

		this.accessorSymbol = accessorSymbol;
		this.defaultSymbol = '=';
		this.defaultValue = defaultValue;
	}

	/**
  * format object to schema
  * @param  {Object} schema - format schema object
  * @param  {Object} object - target object
  * @return {Object} - formatted object
  */

	_createClass(ObjectFormatter, [{
		key: 'format',
		value: function format(schema, object) {
			var _this = this;

			var formatted = {};

			_lodash2.default.each(schema, function (value, key) {
				if ((0, _isobject2.default)(value)) {
					formatted[key] = _this.format(value, object);
				} else if (!_this._isAccessor(value)) {
					formatted[key] = value;
				} else {
					formatted[key] = _this._getValueWithAccessor(value, object);
				}
			});
			return formatted;
		}

		/**
   * check accessor is valid any kind of Accessor or not
   * @param  {any} mabyAccessor
   * @return {Boolean} - true if arg is any kind of Accessor
   */

	}, {
		key: '_isAccessor',
		value: function _isAccessor(mabyAccessor) {
			return this._isSimpleAccessor(mabyAccessor) || this._isCollectionAccessor(mabyAccessor);
		}
		/**
   * check accessor is valid SimpleAccessor or not
   * @param  {any}  mabyAccessor
   * @return {Boolean} - true if arg is SimpleAccessor
   */

	}, {
		key: '_isSimpleAccessor',
		value: function _isSimpleAccessor(mabyAccessor) {
			if (!_lodash2.default.isString(mabyAccessor)) return false;
			return _lodash2.default.startsWith(mabyAccessor, this.accessorSymbol);
		}
		/**
   * check accessor is valid CollectionAccessor or not
   * @param  {any}  mabyAccessor
   * @return {Boolean} - true if arg is CollectionAccessor
   */

	}, {
		key: '_isCollectionAccessor',
		value: function _isCollectionAccessor(mabyAccessor) {
			if (!_lodash2.default.isArray(mabyAccessor)) return false;
			if (mabyAccessor.length !== 2) return false;
			if (!this._isSimpleAccessor(mabyAccessor[0])) return false;
			if (this._isSimpleAccessor(mabyAccessor[1])) return true;
			if (!(0, _isobject2.default)(mabyAccessor[1])) return false;
			return true;
		}

		/**
   * get object's value using any kind of Accessor
   * @param  {Accessor} accessor - Simple/Collection Accessor
   * @param  {Object} object - target object to get value
   * @return {any|undefined} - the value or undefined when accessor's path doesn't exist
   */

	}, {
		key: '_getValueWithAccessor',
		value: function _getValueWithAccessor(accessor, object) {
			if (this._isSimpleAccessor(accessor)) return this._getValueWithSimpleAccessor(accessor, object);
			if (this._isCollectionAccessor(accessor)) return this._getValueWithCollectionAccessor(accessor, object);
			return this.defaultValue;
		}
		/**
   * get object's value using SimpleAccessor
   * @param  {SimpleAccessor} simpleAccessor
   * @param  {Object} object - target object to get value
   * @return {any|undefined} - the value or undefined when accessor's path doesn't exist
   */

	}, {
		key: '_getValueWithSimpleAccessor',
		value: function _getValueWithSimpleAccessor(simpleAccessor, object) {
			var temporaryDefaultValue = this._getDefaultValueFromSimpleAccessor(simpleAccessor);
			var path = this._getPathFromSimpleAccessor(simpleAccessor);
			var value = (0, _recursiveGet2.default)(object, path);
			if (_lodash2.default.isUndefined(value)) return temporaryDefaultValue;
			return value;
		}
		/**
   * get object's value using CollectionAccessor
   * @param  {CollectionAccessor} collectionAccessor
   * @param  {Object} object - target object to get value
   * @return {any|undefined} - the value or undefined when accessor's path doesn't exist
   */

	}, {
		key: '_getValueWithCollectionAccessor',
		value: function _getValueWithCollectionAccessor(collectionAccessor, object) {
			var collectionPath = collectionAccessor[0];
			var mapPath = collectionAccessor[1];
			var collection = this._getValueWithSimpleAccessor(collectionPath, object);
			if (!this._isCollectionReturned(collectionPath, object)) return collection;
			if (this._isSimpleAccessor(mapPath)) return this._getArrayValueWithCollection(mapPath, collection);
			if ((0, _isobject2.default)(mapPath)) return this._getCollectionValueWithCollection(mapPath, collection);
		}

		/**
   * check the value is collection or not
   * @param  {SimpleAccessor} simpleAccessor - SimpleAccessor of path to maybe collection
   * @param  {Object} object - target object to get value
   * @return {Boolean} - true if SimpleAccessor's path is path to collection
   */

	}, {
		key: '_isCollectionReturned',
		value: function _isCollectionReturned(simpleAccessor, object) {
			var path = this._getPathFromSimpleAccessor(simpleAccessor);
			var value = (0, _recursiveGet2.default)(object, path);
			if (_lodash2.default.isUndefined(value)) return false;
			return _lodash2.default.isArray(value);
		}

		/**
   * get arrayed value from collection
   * @param  {SimpleAccessor} simpleAccessor - path to returned values from collection's elements
   * @param  {Object[]} collection - target collection to get values
   * @return {any[]|undefined[]} - the array of value or undefined when accessor's path doesn't exist on collection's elements
   */

	}, {
		key: '_getArrayValueWithCollection',
		value: function _getArrayValueWithCollection(simpleAccessor, collection) {
			var _this2 = this;

			return _lodash2.default.map(collection, function (object) {
				return _this2._getValueWithAccessor(simpleAccessor, object);
			});
		}
		/**
   * get arrayed object from collection
   * @param  {Object} schemaObject - schema of returned objects from collection's elements
   * @param  {Object[]} collection - target collection to get values
   * @return {Object[]} - the array of objects picked from collection
   */

	}, {
		key: '_getCollectionValueWithCollection',
		value: function _getCollectionValueWithCollection(schemaObject, collection) {
			var _this3 = this;

			return _lodash2.default.map(collection, function (object) {
				return _this3.format(schemaObject, object);
			});
		}

		/**
   * get current default value
   * @param  {SimpleAccessor} simpleAccessor
   * @return {any} - returns current default value (`=` notated temporary default or global default)
   */

	}, {
		key: '_getDefaultValueFromSimpleAccessor',
		value: function _getDefaultValueFromSimpleAccessor(simpleAccessor) {
			var splitted = simpleAccessor.split(this.defaultSymbol);
			if (splitted.length !== 2) return this.defaultValue;
			var stringedDefaultValue = splitted[1];
			try {
				var result;
				eval('result=' + stringedDefaultValue); // TODO: don't use eval
				return result;
			} catch (e) {
				return this.defaultValue;
			}
		}

		/**
   * get path string joined with `.`
   * @param  {simpleAccessor} simpleAccessor
   * @return {string} - path string e.g) "a.b.c"
   */

	}, {
		key: '_getPathFromSimpleAccessor',
		value: function _getPathFromSimpleAccessor(simpleAccessor) {
			return simpleAccessor.split(this.defaultSymbol)[0].slice(this.accessorSymbol.length);
		}
	}]);

	return ObjectFormatter;
})();

exports.default = ObjectFormatter;