# object.omit [![NPM version](https://badge.fury.io/js/object.omit.svg)](http://badge.fury.io/js/object.omit)


> Return a copy of an object without the given keys.

## Install
#### Install with [npm](npmjs.org):

```bash
npm i object.omit --save-dev
```

## Run tests

```bash
npm test
```

## Usage

```js
var omit = require('object.omit');
```

Pass a string `key` to omit:

```js
omit({a: 'a', b: 'b', c: 'c'}, 'a')
//=> { b: 'b', c: 'c' }
```

Pass an array of `keys` to omit:

```js
omit({a: 'a', b: 'b', c: 'c'}, ['a', 'c'])
//=> { b: 'b' }
```

Returns the object if no keys are passed:

```js
omit({a: 'a', b: 'b', c: 'c'})
//=> {a: 'a', b: 'b', c: 'c'}
```

Returns an empty object if no value is passed.

```js
omit()
//=> {}
```

## Author

**Jon Schlinkert**
 
+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert) 

### Other javascript/node.js utils

Other projects that I maintain:

  - [arr](https://github.com/jonschlinkert/arr)
  - [arr-diff](https://github.com/jonschlinkert/arr-diff)
  - [array-last](https://github.com/jonschlinkert/array-last)
  - [array-slice](https://github.com/jonschlinkert/array-slice)
  - [array-sum](https://github.com/jonschlinkert/array-sum)
  - [arrayify-compact](https://github.com/jonschlinkert/arrayify-compact)
  - [compact-object](https://github.com/jonschlinkert/compact-object)
  - [delete](https://github.com/jonschlinkert/delete)
  - [for-in](https://github.com/jonschlinkert/for-in)
  - [for-own](https://github.com/jonschlinkert/for-own)
  - [has-any](https://github.com/jonschlinkert/has-any)
  - [has-value](https://github.com/jonschlinkert/has-value)
  - [is-number](https://github.com/jonschlinkert/is-number)
  - [is-plain-object](https://github.com/jonschlinkert/is-plain-object)
  - [mixin-deep](https://github.com/jonschlinkert/mixin-deep)
  - [mixin-object](https://github.com/jonschlinkert/mixin-object)
  - [object-length](https://github.com/jonschlinkert/object-length)
  - [omit-empty](https://github.com/jonschlinkert/omit-empty)
  - [reduce-object](https://github.com/jonschlinkert/reduce-object)


## License
Copyright (c) 2014 Jon Schlinkert, contributors.  
Released under the MIT license

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on October 25, 2014._