/*!
 * object.omit <https://github.com/jonschlinkert/object.omit>
 *
 * Copyright (c) 2014 Jon Schlinkert, contributors.
 * Licensed under the MIT License
 */

'use strict';

var isObject = require('isobject');
var forOwn = require('for-own');

module.exports = function omit(obj, props) {
  if (obj == null || !isObject(obj)) {
    return {};
  }

  // Exit as early as possible
  if (props == null || (Array.isArray(props) && props.length === 0)) {
    return obj;
  }

  if (typeof props === 'string') {
    props = [].slice.call(arguments, 1);
  }

  var o = {};

  if (!Object.keys(obj).length) {
    return o;
  }

  forOwn(obj, function (value, key) {
    if (props.indexOf(key) === -1) {
      o[key] = value;
    }
  });

  return o;
};