import { Command, flags } from '@oclif/command';
import { Plugin } from '@oclif/config';
import Plugins from '../../plugins';
declare type Dependencies = {
    [key: string]: unknown;
    from?: string;
    version?: string;
    name?: string;
    dependencies: {
        [key: string]: Dependencies;
    };
};
export default class PluginsInspect extends Command {
    static description: string;
    static usage: string;
    static examples: string[];
    static strict: boolean;
    static args: {
        name: string;
        description: string;
        required: boolean;
        default: string;
    }[];
    static flags: flags.Input<any>;
    plugins: Plugins;
    allDeps: Dependencies;
    run(): Promise<void>;
    parsePluginName(input: string): Promise<string>;
    findPlugin(pluginName: string): Plugin;
    inspect(pluginName: string): Promise<void>;
    findDepInSharedModules(plugin: Plugin, dependency: string): Promise<string>;
    findDepInTree(plugin: Plugin): Dependencies;
    npmList(cwd: string, depth?: number): Promise<Dependencies>;
}
export {};
