const { chain, isUndefined } = require('lodash');

module.exports = function setWWWAuthenticate(ctx, scheme, fields) {
  const wwwAuth = chain(fields).omitBy(isUndefined)
    .map((val, key) => `${key}="${val.replace(/"/g, '\\"')}"`)
    .value()
    .join(', ');

  ctx.set('WWW-Authenticate', `${scheme} ${wwwAuth}`);
};
