var AuthSdkError = require('./errors/AuthSdkError');

// storage must have getItem and setItem
function storageBuilder(webstorage, storageName) {
  function getStorage() {
    var storageString = webstorage.getItem(storageName);
    storageString = storageString || '{}';
    try {
      return JSON.parse(storageString);
    } catch(e) {
      throw new AuthSdkError('Unable to parse storage string: ' + storageName);
    }
  }

  function setStorage(storage) {
    try {
      var storageString = JSON.stringify(storage);
      webstorage.setItem(storageName, storageString);
    } catch(e) {
      throw new AuthSdkError('Unable to set storage: ' + storageName);
    }
  }

  function clearStorage(key) {
    if (!key) {
      setStorage({});
    }
    var storage = getStorage();
    delete storage[key];
    setStorage(storage);
  }

  function updateStorage(key, value) {
    var storage = getStorage();
    storage[key] = value;
    setStorage(storage);
  }

  return {
    getStorage: getStorage,
    setStorage: setStorage,
    clearStorage: clearStorage,
    updateStorage: updateStorage
  };
}

module.exports = storageBuilder;
