"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");

exports.ServiceManager = void 0;

var _assign = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/object/assign"));

var _map = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/map"));

var _values = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/instance/values"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime-corejs3/helpers/defineProperty"));

var _broadcastChannel = require("broadcast-channel");

var _services = require("./services");

var _features = require("./features");

/*!
 * Copyright (c) 2015-present, Okta, Inc. and/or its affiliates. All rights reserved.
 * The Okta software accompanied by this notice is provided pursuant to the Apache License, Version 2.0 (the "License.")
 *
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and limitations under the License.
 */
class ServiceManager {
  constructor(sdk, options = {}) {
    this.sdk = sdk; // TODO: backwards compatibility, remove in next major version - OKTA-473815

    const {
      autoRenew,
      autoRemove,
      syncStorage
    } = sdk.tokenManager.getOptions();
    this.options = (0, _assign.default)({}, ServiceManager.defaultOptions, {
      autoRenew,
      autoRemove,
      syncStorage
    }, options);
    this.started = false;
    this.services = new _map.default();
    this.onLeaderDuplicate = this.onLeaderDuplicate.bind(this);
    this.onLeader = this.onLeader.bind(this);
    ServiceManager.knownServices.forEach(name => {
      const svc = this.createService(name);

      if (svc) {
        this.services.set(name, svc);
      }
    });
  }

  static canUseLeaderElection() {
    return (0, _features.isBrowser)();
  }

  onLeader() {
    if (this.started) {
      // Start services that requires leadership
      this.startServices();
    }
  }

  onLeaderDuplicate() {}

  isLeader() {
    var _this$elector;

    return !!((_this$elector = this.elector) !== null && _this$elector !== void 0 && _this$elector.isLeader);
  }

  hasLeader() {
    var _this$elector2;

    return (_this$elector2 = this.elector) === null || _this$elector2 === void 0 ? void 0 : _this$elector2.hasLeader;
  }

  isLeaderRequired() {
    var _context;

    return [...(0, _values.default)(_context = this.services).call(_context)].some(srv => srv.requiresLeadership());
  }

  start() {
    if (this.started) {
      return; // noop if services have already started
    } // only start election if a leader is required


    if (this.isLeaderRequired()) {
      this.startElector();
    }

    this.startServices();
    this.started = true;
  }

  stop() {
    this.stopElector();
    this.stopServices();
    this.started = false;
  }

  getService(name) {
    return this.services.get(name);
  }

  startServices() {
    for (const srv of (0, _values.default)(_context2 = this.services).call(_context2)) {
      var _context2;

      const canStart = srv.canStart() && !srv.isStarted() && (srv.requiresLeadership() ? this.isLeader() : true);

      if (canStart) {
        srv.start();
      }
    }
  }

  stopServices() {
    for (const srv of (0, _values.default)(_context3 = this.services).call(_context3)) {
      var _context3;

      srv.stop();
    }
  }

  startElector() {
    this.stopElector();

    if (ServiceManager.canUseLeaderElection()) {
      if (!this.channel) {
        const {
          broadcastChannelName
        } = this.options;
        this.channel = new _broadcastChannel.BroadcastChannel(broadcastChannelName);
      }

      if (!this.elector) {
        this.elector = (0, _broadcastChannel.createLeaderElection)(this.channel);
        this.elector.onduplicate = this.onLeaderDuplicate;
        this.elector.awaitLeadership().then(this.onLeader);
      }
    }
  }

  stopElector() {
    if (this.elector) {
      var _this$elector3, _this$channel;

      (_this$elector3 = this.elector) === null || _this$elector3 === void 0 ? void 0 : _this$elector3.die();
      this.elector = undefined;
      (_this$channel = this.channel) === null || _this$channel === void 0 ? void 0 : _this$channel.close();
      this.channel = undefined;
    }
  }

  createService(name) {
    const tokenManager = this.sdk.tokenManager;
    let service;

    switch (name) {
      case 'autoRenew':
        service = new _services.AutoRenewService(tokenManager, { ...this.options
        });
        break;

      case 'syncStorage':
        service = new _services.SyncStorageService(tokenManager, { ...this.options
        });
        break;

      default:
        throw new Error(`Unknown service ${name}`);
    }

    return service;
  }

}

exports.ServiceManager = ServiceManager;
(0, _defineProperty2.default)(ServiceManager, "knownServices", ['autoRenew', 'syncStorage']);
(0, _defineProperty2.default)(ServiceManager, "defaultOptions", {
  autoRenew: true,
  autoRemove: true,
  syncStorage: true
});
//# sourceMappingURL=ServiceManager.js.map