"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");

exports.GenericRemediator = void 0;

var _reduce = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/instance/reduce"));

var _values = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/instance/values"));

var _map = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/instance/map"));

var _filter = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/instance/filter"));

var _Remediator = require("../Base/Remediator");

var _util = require("./util");

var _proceed = require("../../proceed");

class GenericRemediator extends _Remediator.Remediator {
  canRemediate() {
    // only handle remediations that are able to submit form (xhr)
    if (typeof this.remediation.action !== 'function') {
      return false;
    }

    const inputs = this.getInputs();
    const res = (0, _reduce.default)(inputs).call(inputs, (acc, input) => {
      return acc && (0, _util.hasValidInputValue)(input, (0, _values.default)(this));
    }, true);
    return res;
  }

  getData() {
    var _context2;

    const data = (0, _reduce.default)(_context2 = this.getInputs()).call(_context2, (acc, {
      name
    }) => {
      acc[name] = (0, _values.default)(this)[name];
      return acc;
    }, {});
    return data;
  }

  getNextStep(authClient, _context) {
    const name = this.getName();
    const inputs = this.getInputs();
    /* eslint-disable no-unused-vars, @typescript-eslint/no-unused-vars */
    // excludes transformed fields

    const {
      // http metas have been transformed to action
      href,
      method,
      rel,
      accepts,
      produces,
      // value has been transform to inputs
      value,
      // will be transformed to a function that resolves IdxTransaction
      action,
      ...rest
    } = this.remediation;
    /* eslint-enable no-unused-vars, @typescript-eslint/no-unused-vars */
    // step to handle form submission

    if (action) {
      return { ...rest,
        ...(!!inputs.length && {
          inputs
        }),
        action: async params => {
          return (0, _proceed.proceed)(authClient, {
            step: name,
            ...params
          });
        }
      };
    } // return whole remediation data for other steps, eg "redirect-idp"


    return { ...this.remediation
    };
  }

  getInputs() {
    var _context3, _context4, _context5;

    return (0, _map.default)(_context3 = (0, _map.default)(_context4 = (0, _filter.default)(_context5 = this.remediation.value || []).call(_context5, ({
      name
    }) => name !== 'stateHandle')).call(_context4, _util.unwrapFormValue)).call(_context3, input => {
      // use string as default input type
      input.type = input.type || 'string';
      return input;
    });
  }

}

exports.GenericRemediator = GenericRemediator;
//# sourceMappingURL=GenericRemediator.js.map