import { RemediationValues, Remediator } from './remediators';
import { IdxFeature, NextStep, RemediateOptions, RemediationResponse } from './types';
import { IdxMessage, IdxRemediation, IdxRemediationValue, IdxResponse } from './types/idx-js';
import { OktaAuthInterface } from '../types';
export declare function isTerminalResponse(idxResponse: IdxResponse): boolean;
export declare function canSkipFn(idxResponse: IdxResponse): boolean;
export declare function canResendFn(idxResponse: IdxResponse): boolean;
export declare function getMessagesFromIdxRemediationValue(value?: IdxRemediationValue[]): IdxMessage[] | undefined;
export declare function getMessagesFromResponse(idxResponse: IdxResponse): IdxMessage[];
export declare function getEnabledFeatures(idxResponse: IdxResponse): IdxFeature[];
export declare function getAvailableSteps(authClient: OktaAuthInterface, idxResponse: IdxResponse, useGenericRemediator?: boolean): NextStep[];
export declare function filterValuesForRemediation(idxResponse: IdxResponse, remediationName: string, values: RemediationValues): RemediationValues;
export declare function getRemediator(idxRemediations: IdxRemediation[], values: RemediationValues, options: RemediateOptions): Remediator | undefined;
export declare function getNextStep(authClient: OktaAuthInterface, remediator: Remediator, idxResponse: IdxResponse): NextStep;
export declare function handleIdxError(authClient: OktaAuthInterface, e: any, remediator?: any): RemediationResponse;
