"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");

exports.unwrapFormValue = unwrapFormValue;
exports.hasValidInputValue = hasValidInputValue;

var _entries = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/object/entries"));

var _map = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/instance/map"));

var _keys = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/object/keys"));

var _includes = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/instance/includes"));

var _reduce = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/instance/reduce"));

var _find = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/instance/find"));

var _filter = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/instance/filter"));

var _stringify = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/json/stringify"));

var _errors = require("../../../errors");

/* eslint-disable complexity */
function unwrapFormValue(remediation) {
  const res = {};

  for (const [key, value] of (0, _entries.default)(remediation)) {
    if (value === null || typeof value === 'undefined') {
      continue;
    }

    if (Array.isArray(value)) {
      res[key] = (0, _map.default)(value).call(value, unwrapFormValue);
    } else if (typeof value === 'object') {
      var _context, _context2;

      const formKeys = (0, _keys.default)(value); // detect patterns like:
      // value -> form -> value | form -> value

      if ((0, _includes.default)(_context = ['value', 'form']).call(_context, key) && formKeys.length === 1 && (0, _includes.default)(_context2 = ['value', 'form']).call(_context2, formKeys[0])) {
        // unwrap nested form
        const unwrappedForm = unwrapFormValue(value);
        (0, _entries.default)(unwrappedForm).forEach(([key, value]) => {
          res[key] = value;
        });
      } else {
        // dfs
        res[key] = unwrapFormValue(value);
      }
    } else {
      // handle primitive value
      res[key] = value;
    }
  }

  return res;
} // only check if value is required for now
// TODO: support SDK layer type based input validation


function hasValidInputValue(input, values) {
  const fn = (input, values, requiredTracker) => {
    const {
      name,
      value,
      type,
      options,
      required
    } = input;
    const isRequired = required || requiredTracker; // handle nested value - all required fields should be avaiable in values 

    if (Array.isArray(value)) {
      return (0, _reduce.default)(value).call(value, (acc, item) => {
        return acc && fn(item, values[name], isRequired); // recursive call
      }, true);
    } // handle options field
    // 1. object type options - check if each object field is required and value can be found from the selectedOption
    // 2. primitive options - required field is avaiable from top level
    // 3. unknown format - pass to backend for validation


    if (options) {
      // object type options
      if (type === 'object') {
        var _context4, _context5;

        const selectedOption = values[name];

        if (!selectedOption) {
          return false;
        }

        if (!selectedOption.id) {
          // unknown option format, pass to backend for validation
          return true;
        }

        const optionSchema = (0, _find.default)(options).call(options, option => {
          var _context3;

          const idSchema = (0, _find.default)(_context3 = option.value).call(_context3, ({
            name
          }) => name === 'id');
          return idSchema.value === selectedOption.id;
        });

        if (!optionSchema) {
          return false;
        }

        return (0, _reduce.default)(_context4 = (0, _filter.default)(_context5 = optionSchema.value).call(_context5, ({
          required
        }) => !!required)).call(_context4, (acc, {
          name
        }) => {
          return acc && !!selectedOption[name];
        }, true);
      } // primitive options, not required - always valid


      if (required === false) {
        return true;
      } // primitive options, required - check if value is available


      if (required === true) {
        return !!values[name];
      } // unknown options, throw


      throw new _errors.AuthSdkError(`Unknown options type, ${(0, _stringify.default)(input)}`);
    } // base case


    if (!isRequired) {
      return true;
    }

    return !!(values && values[name]);
  };

  return fn(input, values, false);
}
//# sourceMappingURL=util.js.map