"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");

exports.ReEnrollAuthenticator = void 0;

var _values = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/instance/values"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime-corejs3/helpers/defineProperty"));

var _Remediator = require("./Base/Remediator");

/*!
 * Copyright (c) 2015-present, Okta, Inc. and/or its affiliates. All rights reserved.
 * The Okta software accompanied by this notice is provided pursuant to the Apache License, Version 2.0 (the "License.")
 *
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and limitations under the License.
 */
class ReEnrollAuthenticator extends _Remediator.Remediator {
  mapCredentials() {
    const {
      newPassword
    } = (0, _values.default)(this);

    if (!newPassword) {
      return;
    }

    return {
      passcode: newPassword
    };
  }

  getInputCredentials(input) {
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    const challengeType = this.getAuthenticator().type;
    const name = challengeType === 'password' ? 'newPassword' : 'verificationCode';
    return { ...input.form.value[0],
      name
    };
  }

}

exports.ReEnrollAuthenticator = ReEnrollAuthenticator;
(0, _defineProperty2.default)(ReEnrollAuthenticator, "remediationName", 'reenroll-authenticator');
//# sourceMappingURL=ReEnrollAuthenticator.js.map