import { Token, Tokens, TokenType, TokenManagerOptions, OktaAuthInterface, TokenManagerErrorEventHandler, TokenManagerEventHandler, TokenManagerInterface, RefreshToken, AccessTokenCallback, IDTokenCallback, RefreshTokenCallback } from './types';
export declare const EVENT_EXPIRED = "expired";
export declare const EVENT_RENEWED = "renewed";
export declare const EVENT_ADDED = "added";
export declare const EVENT_REMOVED = "removed";
export declare const EVENT_ERROR = "error";
export declare class TokenManager implements TokenManagerInterface {
    private sdk;
    private clock;
    private emitter;
    private storage;
    private state;
    private options;
    on: (event: string, handler: TokenManagerErrorEventHandler | TokenManagerEventHandler, context?: object) => void;
    off: (event: string, handler?: TokenManagerErrorEventHandler | TokenManagerEventHandler) => void;
    constructor(sdk: OktaAuthInterface, options?: TokenManagerOptions);
    start(): void;
    stop(): void;
    getOptions(): TokenManagerOptions;
    getExpireTime(token: any): number;
    hasExpired(token: any): boolean;
    emitExpired(key: any, token: any): void;
    emitRenewed(key: any, freshToken: any, oldToken: any): void;
    emitAdded(key: any, token: any): void;
    emitRemoved(key: any, token?: any): void;
    emitError(error: any): void;
    emitEventsForCrossTabsStorageUpdate(newValue: any, oldValue: any): void;
    clearExpireEventTimeout(key: any): void;
    clearExpireEventTimeoutAll(): void;
    setExpireEventTimeout(key: any, token: any): void;
    setExpireEventTimeoutAll(): void;
    resetExpireEventTimeoutAll(): void;
    add(key: any, token: Token): void;
    getSync(key: any): any;
    get(key: any): Promise<any>;
    getTokensSync(): Tokens;
    getTokens(): Promise<Tokens>;
    getStorageKeyByType(type: TokenType): string;
    private getTokenType;
    setTokens(tokens: Tokens, accessTokenCb?: AccessTokenCallback, idTokenCb?: IDTokenCallback, refreshTokenCb?: RefreshTokenCallback): void;
    remove(key: any): void;
    renewToken(token: any): Promise<Token | undefined>;
    validateToken(token: Token): void;
    renew(key: any): Promise<Token | undefined>;
    clear(): void;
    clearPendingRemoveTokens(): void;
    getTokensFromStorageValue(value: any): any;
    updateRefreshToken(token: RefreshToken): void;
    removeRefreshToken(): void;
    addPendingRemoveFlags(): void;
}
