/*!
 * Copyright (c) 2015-present, Okta, Inc. and/or its affiliates. All rights reserved.
 * The Okta software accompanied by this notice is provided pursuant to the Apache License, Version 2.0 (the "License.")
 *
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and limitations under the License.
 */

import { decodeToken } from '../decodeToken.js';
import { exchangeCodeForTokens } from '../exchangeCodeForTokens.js';
import '../../errors/WWWAuthError.js';
import '../../crypto/node.js';
import { prepareTokenParams } from '../util/prepareTokenParams.js';
import '../types/Token.js';

function createBaseTokenAPI(sdk) {
    const token = {
        prepareTokenParams: prepareTokenParams.bind(null, sdk),
        exchangeCodeForTokens: exchangeCodeForTokens.bind(null, sdk),
        decode: decodeToken,
    };
    return token;
}

export { createBaseTokenAPI };
//# sourceMappingURL=baseApi.js.map
