import { Token, Tokens, TokenType, TokenManagerOptions, TokenManagerErrorEventHandler, TokenManagerSetStorageEventHandler, TokenManagerRenewEventHandler, TokenManagerEventHandler, TokenManagerInterface, RefreshToken, AccessTokenCallback, IDTokenCallback, RefreshTokenCallback, EVENT_RENEWED, EVENT_ADDED, EVENT_ERROR, EVENT_EXPIRED, EVENT_REMOVED, EVENT_SET_STORAGE, OktaAuthOAuthInterface } from './types';
import { StorageProvider } from '../storage/types';
export declare class TokenManager implements TokenManagerInterface {
    private sdk;
    private clock;
    private emitter;
    private storage;
    private state;
    private options;
    on(event: typeof EVENT_RENEWED, handler: TokenManagerRenewEventHandler, context?: object): void;
    on(event: typeof EVENT_ERROR, handler: TokenManagerErrorEventHandler, context?: object): void;
    on(event: typeof EVENT_SET_STORAGE, handler: TokenManagerSetStorageEventHandler, context?: object): void;
    on(event: typeof EVENT_EXPIRED | typeof EVENT_ADDED | typeof EVENT_REMOVED, handler: TokenManagerEventHandler, context?: object): void;
    off(event: typeof EVENT_RENEWED, handler?: TokenManagerRenewEventHandler): void;
    off(event: typeof EVENT_ERROR, handler?: TokenManagerErrorEventHandler): void;
    off(event: typeof EVENT_SET_STORAGE, handler?: TokenManagerSetStorageEventHandler): void;
    off(event: typeof EVENT_EXPIRED | typeof EVENT_ADDED | typeof EVENT_REMOVED, handler?: TokenManagerEventHandler): void;
    constructor(sdk: OktaAuthOAuthInterface, options?: TokenManagerOptions);
    start(): void;
    stop(): void;
    isStarted(): boolean;
    getOptions(): TokenManagerOptions;
    getExpireTime(token: any): number;
    hasExpired(token: any): boolean;
    emitExpired(key: any, token: any): void;
    emitRenewed(key: any, freshToken: any, oldToken: any): void;
    emitAdded(key: any, token: any): void;
    emitRemoved(key: any, token?: any): void;
    emitError(error: any): void;
    clearExpireEventTimeout(key: any): void;
    clearExpireEventTimeoutAll(): void;
    setExpireEventTimeout(key: any, token: any): void;
    setExpireEventTimeoutAll(): void;
    resetExpireEventTimeoutAll(): void;
    add(key: any, token: Token): void;
    getSync(key: any): Token;
    get(key: any): Promise<Token>;
    getTokensSync(): Tokens;
    getTokens(): Promise<Tokens>;
    getStorageKeyByType(type: TokenType): string;
    private getTokenType;
    private emitSetStorageEvent;
    getStorage(): StorageProvider;
    setTokens(tokens: Tokens, accessTokenCb?: AccessTokenCallback, idTokenCb?: IDTokenCallback, refreshTokenCb?: RefreshTokenCallback): void;
    remove(key: any): void;
    renewToken(token: any): Promise<Token | undefined>;
    validateToken(token: Token): void;
    renew(key: any): Promise<Token | undefined>;
    clear(): void;
    clearPendingRemoveTokens(): void;
    updateRefreshToken(token: RefreshToken): void;
    removeRefreshToken(): void;
    addPendingRemoveFlags(): void;
}
