/*!
 * Copyright (c) 2015-present, Okta, Inc. and/or its affiliates. All rights reserved.
 * The Okta software accompanied by this notice is provided pursuant to the Apache License, Version 2.0 (the "License.")
 *
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and limitations under the License.
 */

import { SelectAuthenticator } from './Base/SelectAuthenticator.js';

class SelectAuthenticatorUnlockAccount extends SelectAuthenticator {
    constructor() {
        super(...arguments);
        this.map = {
            identifier: ['username']
        };
    }
    canRemediate() {
        const identifier = this.getData('identifier');
        return !!identifier && super.canRemediate();
    }
    mapAuthenticator(remediationValue) {
        var _a, _b, _c;
        const authenticatorMap = super.mapAuthenticator(remediationValue);
        const methodTypeOption = (_a = this.selectedOption) === null || _a === void 0 ? void 0 : _a.value.form.value.find(({ name }) => name === 'methodType');
        const methodTypeValue = this.values.methodType ||
            (methodTypeOption === null || methodTypeOption === void 0 ? void 0 : methodTypeOption.value) || ((_c = (_b = methodTypeOption === null || methodTypeOption === void 0 ? void 0 : methodTypeOption.options) === null || _b === void 0 ? void 0 : _b[0]) === null || _c === void 0 ? void 0 : _c.value);
        if (methodTypeValue) {
            return Object.assign(Object.assign({}, authenticatorMap), { methodType: methodTypeValue });
        }
        return authenticatorMap;
    }
    getInputUsername() {
        return { name: 'username', type: 'string' };
    }
}
SelectAuthenticatorUnlockAccount.remediationName = 'select-authenticator-unlock-account';

export { SelectAuthenticatorUnlockAccount };
//# sourceMappingURL=SelectAuthenticatorUnlockAccount.js.map
