"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});
var _arguments = arguments;
var middleware = function middleware(req, res, next, listenerFunc) {
	var prevRender = req.app.render;
	req.app.render = function (view, options, callback) {
		var newCallback = function newCallback(err, rendering) {
			listenerFunc(req, res, rendering, view, options);
			callback.apply(undefined, _arguments);
		};
		prevRender.call(undefined, view, options, newCallback);
	};
	next();
};

var create = function create(listenerFunc) {
	return function (req, res, next) {
		middleware(req, res, next, listenerFunc);
	};
};

exports["default"] = { create: create };
module.exports = exports["default"];
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9pbmRleC5qcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSxJQUFJLFVBQVUsR0FBRyxTQUFiLFVBQVUsQ0FBSSxHQUFHLEVBQUUsR0FBRyxFQUFFLElBQUksRUFBRSxZQUFZLEVBQUs7QUFDbEQsS0FBSSxVQUFVLEdBQUcsR0FBRyxDQUFDLEdBQUcsQ0FBQyxNQUFNLENBQUM7QUFDaEMsSUFBRyxDQUFDLEdBQUcsQ0FBQyxNQUFNLEdBQUcsVUFBQyxJQUFJLEVBQUUsT0FBTyxFQUFFLFFBQVEsRUFBSztBQUM3QyxNQUFJLFdBQVcsR0FBRyxTQUFkLFdBQVcsQ0FBSSxHQUFHLEVBQUUsU0FBUyxFQUFLO0FBQ3JDLGVBQVksQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLFNBQVMsRUFBRSxJQUFJLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFDakQsV0FBUSxDQUFDLEtBQUssdUJBQWlCLENBQUM7R0FDaEMsQ0FBQztBQUNGLFlBQVUsQ0FBQyxJQUFJLFlBQU8sSUFBSSxFQUFFLE9BQU8sRUFBRSxXQUFXLENBQUMsQ0FBQztFQUNsRCxDQUFDO0FBQ0YsS0FBSSxFQUFFLENBQUM7Q0FDUCxDQUFDOztBQUVGLElBQUksTUFBTSxHQUFHLFNBQVQsTUFBTSxDQUFHLFlBQVksRUFBSTtBQUM1QixRQUFPLFVBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxJQUFJLEVBQUs7QUFDMUIsWUFBVSxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsSUFBSSxFQUFFLFlBQVksQ0FBQyxDQUFDO0VBQ3pDLENBQUM7Q0FDRixDQUFDOztxQkFFYSxFQUFFLE1BQU0sRUFBTixNQUFNLEVBQUUiLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VzQ29udGVudCI6WyJsZXQgbWlkZGxld2FyZSA9IChyZXEsIHJlcywgbmV4dCwgbGlzdGVuZXJGdW5jKSA9PiB7XG5cdGxldCBwcmV2UmVuZGVyID0gcmVxLmFwcC5yZW5kZXI7XG5cdHJlcS5hcHAucmVuZGVyID0gKHZpZXcsIG9wdGlvbnMsIGNhbGxiYWNrKSA9PiB7XG5cdFx0bGV0IG5ld0NhbGxiYWNrID0gKGVyciwgcmVuZGVyaW5nKSA9PiB7XG5cdFx0XHRsaXN0ZW5lckZ1bmMocmVxLCByZXMsIHJlbmRlcmluZywgdmlldywgb3B0aW9ucyk7XG5cdFx0XHRjYWxsYmFjay5hcHBseSh0aGlzLCBhcmd1bWVudHMpO1xuXHRcdH07XG5cdFx0cHJldlJlbmRlci5jYWxsKHRoaXMsIHZpZXcsIG9wdGlvbnMsIG5ld0NhbGxiYWNrKTtcblx0fTtcblx0bmV4dCgpO1xufTtcblxubGV0IGNyZWF0ZSA9IGxpc3RlbmVyRnVuYyA9PiB7XG5cdHJldHVybiAocmVxLCByZXMsIG5leHQpID0+IHtcblx0XHRtaWRkbGV3YXJlKHJlcSwgcmVzLCBuZXh0LCBsaXN0ZW5lckZ1bmMpO1xuXHR9O1xufTtcblxuZXhwb3J0IGRlZmF1bHQgeyBjcmVhdGUgfVxuIl19