'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-4e2eca71.js');

const alertBoxCss = ".alert-box{position:relative}.alert-box .close-button{position:absolute;top:10px;right:10px;cursor:pointer;font-size:21px;font-weight:700;line-height:1;color:#8a6d3b;opacity:0.2}.alert-box .close-button:hover{text-decoration:none;color:#000;opacity:0.5}";

const AlertBox = class {
  constructor(hostRef) {
    index.registerInstance(this, hostRef);
    this.type = 'info';
    this.message = undefined;
    this.noIcon = true;
    this.noButton = false;
    this.isVisible = true;
  }
  onClose(evt) {
    evt.stopPropagation();
    this.isVisible = !this.isVisible;
  }
  render() {
    const classList = `alert-box alert alert-${this.type} ${this.noIcon && 'no-icon'}`;
    return (index.h(index.Host, null, this.isVisible && index.h("div", { class: classList }, !this.noButton && index.h("a", { class: "close-button", onClick: (evt) => this.onClose(evt) }, "\u00D7"), index.h("div", { class: "message" }, this.message))));
  }
};
AlertBox.style = alertBoxCss;

exports.alert_box = AlertBox;
