'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-4e2eca71.js');
const eventService = require('./event-service-b85ec7db.js');
const internalEventTypes = require('./internal-event-types-41327b12.js');
require('./internal-download-as-event-449d5871.js');
require('./internal-dropdown-value-selected-event-7cbd8ed8.js');

const copyResourceLinkButtonCss = ".copy-resource-link-button a.icon-link:hover{text-decoration:none}";

const CopyResourceLinkButton = class {
  constructor(hostRef) {
    index.registerInstance(this, hostRef);
    this.uri = undefined;
    this.classes = undefined;
  }
  onButtonClick() {
    eventService.EventService.emitFromInnerElement(this.hostElement, internalEventTypes.InternalEventType.INTERNAL_SHOW_RESOURCE_COPY_LINK_DIALOG_EVENT, { copyLink: this.uri });
  }
  render() {
    const classList = `copy-resource-link-button ${this.classes || ''}`;
    return (index.h(index.Host, { class: classList }, index.h("a", { class: "icon-link", href: "#", onClick: () => this.onButtonClick() })));
  }
  get hostElement() { return index.getElement(this); }
};
CopyResourceLinkButton.style = copyResourceLinkButtonCss;

exports.copy_resource_link_button = CopyResourceLinkButton;
