'use strict';

const internalDownloadAsEvent = require('./internal-download-as-event-449d5871.js');
const internalDropdownValueSelectedEvent = require('./internal-dropdown-value-selected-event-7cbd8ed8.js');
const internalEventTypes = require('./internal-event-types-41327b12.js');

const MessageType = {
  SUCCESS: 'success',
  ERROR: 'error',
  WARNING: 'warning',
  INFO: 'info',
};
const MessageCode = {
  RESOURCE_LINK_COPIED_SUCCESSFULLY: 'resource_link_copied_successfully',
  QUERY_IS_RUNNING: 'query_is_running',
  EXPLAIN_NOT_ALLOWED: 'explain_not_allowed',
  EXPLAIN_EXIT_FULLSCREEN: 'explain_exit_fullscreen'
};
class InternalNotificationMessageEvent {
  constructor(code, messageType, message) {
    this.TYPE = internalEventTypes.InternalEventType.INTERNAL_NOTIFICATION_MESSAGE_EVENT;
    this.OUTPUT_TYPE = internalDownloadAsEvent.OutputEventType.OUTPUT_NOTIFICATION_MESSAGE_EVENT;
    this.payload = { code, messageType, message };
  }
}

class InternalShowResourceCopyLinkDialogEvent {
  constructor(copyLink) {
    this.TYPE = internalEventTypes.InternalEventType.INTERNAL_SHOW_RESOURCE_COPY_LINK_DIALOG_EVENT;
    this.payload = { copyLink };
  }
}

class InternalQueryExecuted {
  constructor(duration, tabId) {
    this.TYPE = internalEventTypes.InternalEventType.INTERNAL_QUERY_EXECUTED;
    this.OUTPUT_TYPE = internalDownloadAsEvent.OutputEventType.OUTPUT_QUERY_EXECUTED;
    this.payload = { duration, tabId };
  }
}

class InternalQueryEvent {
  constructor(request, query, queryMode, queryType, pageSize) {
    this.TYPE = internalEventTypes.InternalEventType.INTERNAL_QUERY_EVENT;
    this.OUTPUT_TYPE = internalDownloadAsEvent.OutputEventType.OUTPUT_QUERY_EVENT;
    this.payload = { request, query, queryMode, queryType, pageSize };
  }
}

class InternalCountQueryEvent {
  constructor(request, query, queryMode, queryType, pageSize) {
    this.TYPE = internalEventTypes.InternalEventType.INTERNAL_COUNT_QUERY_EVENT;
    this.OUTPUT_TYPE = internalDownloadAsEvent.OutputEventType.OUTPUT_COUNT_QUERY_EVENT;
    this.payload = { request, query, queryMode, queryType, pageSize };
  }
}

class InternalCountQueryResponseEvent {
  constructor(response) {
    this.TYPE = internalEventTypes.InternalEventType.INTERNAL_COUNT_QUERY_RESPONSE_EVENT;
    this.OUTPUT_TYPE = internalDownloadAsEvent.OutputEventType.OUTPUT_COUNT_QUERY_RESPONSE_EVENT;
    this.payload = { response };
  }
}

class InternalRequestAbortedEvent {
  constructor(request, queryMode) {
    this.TYPE = internalEventTypes.InternalEventType.INTERNAL_REQUEST_ABORTED_EVENT;
    this.OUTPUT_TYPE = internalDownloadAsEvent.OutputEventType.OUTPUT_REQUEST_ABORTED;
    this.payload = { request, queryMode };
  }
}

/**
 * The purpose of this service is to mitigate the issue where the stencil builtin Event decorator
 * doesn't work properly when injected in a service. The issue is similar to this
 * https://github.com/ionic-team/stencil/issues/2563 and even there are many mentions of the exactly
 * the same behavior we stumbled upon.
 *
 * This service is intended to be used in other services in order to help firing events which then
 * is expected to be caught by the stencil yasgui component.
 * The way we workaround the issue above to dispatch native DOM events instead of events through the
 * builtin EventEmitter in the stencil. This is kind of awkward approach, because we now have two
 * separate event systems in place.
 */
class EventService {
  /**
   * Emits an <code>internalEvent</code> wrapped in a native CustomEvent.
   *
   * @param internalEvent The event {@link InternalEvent}.
   */
  emit(internalEvent) {
    return EventService.emitInternalEvent(this._hostElement, internalEvent);
  }
  emitEvent(element, type, payload) {
    return EventService.emitFromInnerElement(element, type, payload);
  }
  static emitFromInnerElement(element, type, payload) {
    if (!element) {
      return;
    }
    const innerEvent = EventService.toInnerEvent(type, payload);
    if (innerEvent) {
      return EventService.emitInternalEvent(element.closest('.yasgui-host-element'), innerEvent);
    }
    const event = new CustomEvent(type, { detail: payload });
    element.dispatchEvent(event);
    return event;
  }
  static emitInternalEvent(element, internalEvent) {
    if (!element) {
      return;
    }
    const event = new CustomEvent(internalEvent.TYPE, { detail: internalEvent });
    element.dispatchEvent(event);
    return event;
  }
  static toInnerEvent(type, payload) {
    switch (type) {
      case internalEventTypes.InternalEventType.INTERNAL_DOWNLOAD_AS_EVENT:
        return new internalDownloadAsEvent.InternalDownloadAsEvent(payload.value, payload.pluginName, payload.query, payload.infer, payload.sameAs);
      case internalEventTypes.InternalEventType.INTERNAL_DROPDOWN_VALUE_SELECTED_EVENT:
        return new internalDropdownValueSelectedEvent.InternalDropdownValueSelectedEvent(payload.value);
      case internalEventTypes.InternalEventType.INTERNAL_NOTIFICATION_MESSAGE_EVENT:
        return new InternalNotificationMessageEvent(payload.code, payload.messageType, payload.message);
      case internalEventTypes.InternalEventType.INTERNAL_SHOW_RESOURCE_COPY_LINK_DIALOG_EVENT:
        return new InternalShowResourceCopyLinkDialogEvent(payload.copyLink);
      case internalEventTypes.InternalEventType.INTERNAL_QUERY_EXECUTED:
        return new InternalQueryExecuted(payload.duration, payload.tabId);
      case internalEventTypes.InternalEventType.INTERNAL_QUERY_EVENT:
        return new InternalQueryEvent(payload.request, payload.query, payload.queryMode, payload.queryType, payload.pageSize);
      case internalEventTypes.InternalEventType.INTERNAL_COUNT_QUERY_EVENT:
        return new InternalCountQueryEvent(payload.request, payload.query, payload.queryMode, payload.queryType, payload.pageSize);
      case internalEventTypes.InternalEventType.INTERNAL_COUNT_QUERY_RESPONSE_EVENT:
        return new InternalCountQueryResponseEvent(payload.response);
      case internalEventTypes.InternalEventType.INTERNAL_REQUEST_ABORTED_EVENT:
        return new InternalRequestAbortedEvent(payload.request, payload.queryMode);
      default:
        throw Error('Can\'t find internal event definition for type: ' + type);
    }
  }
  get hostElement() {
    return this._hostElement;
  }
  set hostElement(value) {
    this._hostElement = value;
  }
}

exports.EventService = EventService;
exports.InternalNotificationMessageEvent = InternalNotificationMessageEvent;
exports.MessageCode = MessageCode;
exports.MessageType = MessageType;
