'use strict';

const internalEventTypes = require('./internal-event-types-41327b12.js');

exports.OutputEventType = void 0;
(function (OutputEventType) {
  OutputEventType["OUTPUT_COUNT_QUERY_EVENT"] = "countQuery";
  OutputEventType["OUTPUT_COUNT_QUERY_RESPONSE_EVENT"] = "countQueryResponse";
  OutputEventType["OUTPUT_REQUEST_ABORTED"] = "requestAborted";
  OutputEventType["OUTPUT_QUERY_EVENT"] = "query";
  OutputEventType["OUTPUT_DOWNLOAD_AS_EVENT"] = "downloadAs";
  OutputEventType["OUTPUT_NOTIFICATION_MESSAGE_EVENT"] = "notificationMessage";
  OutputEventType["OUTPUT_QUERY_EXECUTED"] = "queryExecuted";
  OutputEventType["OUTPUT_SAVED_QUERY_OPENED"] = "saveQueryOpened";
})(exports.OutputEventType || (exports.OutputEventType = {}));

class InternalDownloadAsEvent {
  constructor(value, pluginName, query, infer, sameAs) {
    this.TYPE = internalEventTypes.InternalEventType.INTERNAL_DOWNLOAD_AS_EVENT;
    this.OUTPUT_TYPE = exports.OutputEventType.OUTPUT_DOWNLOAD_AS_EVENT;
    this.payload = { value, pluginName, query, infer, sameAs };
  }
}

exports.InternalDownloadAsEvent = InternalDownloadAsEvent;
