'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-4e2eca71.js');
const svgUtil = require('./svg-util-24ae60b9.js');

const loaderComponentCss = ":host{display:block}:host .loader-component{text-align:center}";

const LoaderComponent = class {
  constructor(hostRef) {
    index.registerInstance(this, hostRef);
    this.timeFormattingService = undefined;
    this.showQueryProgress = false;
    this.message = undefined;
    this.additionalMessage = '';
    this.size = undefined;
    this.hidden = undefined;
    this.queryProgress = '';
  }
  startInterval() {
    this.updateState();
  }
  updateState() {
    if (this.hidden) {
      this.clearLoader();
      this.hostElement.classList.add('hidden');
    }
    else {
      this.hostElement.classList.remove('hidden');
      if (this.showQueryProgress && !this.updateLoaderInterval) {
        this.queryProgress = '';
        this.startTime = Date.now();
        this.updateLoaderMessage();
        this.updateLoaderInterval = setInterval(() => {
          this.updateLoaderMessage();
        }, 1000);
      }
    }
  }
  updateLoaderMessage() {
    if (this.showQueryProgress) {
      const durationTime = (Date.now() - this.startTime);
      const durationTimeInSeconds = durationTime / 1000;
      if (durationTimeInSeconds > 10) {
        this.queryProgress = LoaderComponent.EMPTY_QUERY_PROGRESS + this.timeFormattingService.getHumanReadableSeconds(durationTime);
      }
    }
    else {
      this.clearLoader();
    }
  }
  componentDidLoad() {
    // As documentation said "The @Watch() decorator does not fire when a component initially loads."
    // yasgui instance will not be created if we set configuration when component is loaded, which
    // will be most case of the component usage. So we call the method manually when component is
    // loaded. More info https://github.com/TriplyDB/Yasgui/issues/143
    this.updateState();
  }
  disconnectedCallback() {
    this.clearLoader();
  }
  clearLoader() {
    if (this.updateLoaderInterval) {
      clearInterval(this.updateLoaderInterval);
      this.updateLoaderInterval = null;
    }
    this.queryProgress = '';
  }
  render() {
    return (index.h(index.Host, { class: 'ontotext-yasgui-loader hidden' }, index.h("slot", null, !this.hidden &&
      index.h("div", { class: 'loader-component' }, index.h("div", { innerHTML: svgUtil.SvgUtil.getLoaderSvgTag(this.size) }), index.h("div", null, this.message, " ", this.queryProgress), index.h("div", null, this.additionalMessage)))));
  }
  get hostElement() { return index.getElement(this); }
  static get watchers() { return {
    "hidden": ["startInterval"]
  }; }
};
LoaderComponent.EMPTY_QUERY_PROGRESS = '... ';
LoaderComponent.style = loaderComponentCss;

exports.loader_component = LoaderComponent;
