import { h, Host } from '@stencil/core';
/**
 * Implementation of dismissible alert box component which can be configured.
 */
export class AlertBox {
  constructor() {
    this.type = 'info';
    this.message = undefined;
    this.noIcon = true;
    this.noButton = false;
    this.isVisible = true;
  }
  onClose(evt) {
    evt.stopPropagation();
    this.isVisible = !this.isVisible;
  }
  render() {
    const classList = `alert-box alert alert-${this.type} ${this.noIcon && 'no-icon'}`;
    return (h(Host, null, this.isVisible && h("div", { class: classList }, !this.noButton && h("a", { class: "close-button", onClick: (evt) => this.onClose(evt) }, "\u00D7"), h("div", { class: "message" }, this.message))));
  }
  static get is() { return "alert-box"; }
  static get originalStyleUrls() {
    return {
      "$": ["alert-box.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["alert-box.css"]
    };
  }
  static get properties() {
    return {
      "type": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "AlertBoxType",
          "resolved": "\"danger\" | \"help\" | \"info\" | \"success\" | \"warning\"",
          "references": {
            "AlertBoxType": {
              "location": "local"
            }
          }
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Defines the alert type which is represented by different color, background and icon.\nDefault is <code>\"info\"</code>."
        },
        "attribute": "type",
        "reflect": false,
        "defaultValue": "'info'"
      },
      "message": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The message which should be displayed in the alert. If the message is not provided, then the\nalert is not displayed."
        },
        "attribute": "message",
        "reflect": false
      },
      "noIcon": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Configures if the icon in the alert should be displayed or not.\nDefault is <code>true</code>"
        },
        "attribute": "no-icon",
        "reflect": false,
        "defaultValue": "true"
      },
      "noButton": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Configures if the close button in the alert should be displayed or not.\nDefault is <code>false</code>"
        },
        "attribute": "no-button",
        "reflect": false,
        "defaultValue": "false"
      }
    };
  }
  static get states() {
    return {
      "isVisible": {}
    };
  }
}
