import { h, Host } from '@stencil/core';
import { HtmlUtil } from '../../services/utils/html-util';
export class ConfirmationDialog {
  constructor() {
    this.translationService = undefined;
    this.config = {
      title: 'Confirmation',
      message: 'Confirming?'
    };
  }
  /**
   * Handles the Escape key keydown event and closes the dialog.
   * @param ev The keyboard event.
   */
  keydownListener(ev) {
    if (ev.key === 'Escape') {
      this.internalConfirmationRejectedEvent.emit();
    }
  }
  preventLeavingDialog(ev) {
    HtmlUtil.preventLeavingDialog(this.hostElement, ev);
  }
  onClose(evt) {
    const target = evt.target;
    evt.stopPropagation();
    const isOverlay = target.classList.contains('dialog-overlay');
    const isCloseButton = target.classList.contains('close-button');
    const isCancelButton = target.classList.contains('cancel-button');
    if (isOverlay || isCloseButton || isCancelButton) {
      this.internalConfirmationRejectedEvent.emit();
    }
  }
  onConfirm(evt) {
    evt.stopPropagation();
    this.internalConfirmationApprovedEvent.emit();
  }
  componentDidLoad() {
    this.hostElement.addEventListener('keydown', this.preventLeavingDialog.bind(this));
    this.documentOverflow = HtmlUtil.hideDocumentBodyOverflow();
    this.cancelButton.focus();
  }
  disconnectedCallback() {
    this.hostElement.removeEventListener('keydown', this.preventLeavingDialog.bind(this));
    HtmlUtil.setDocumentBodyOverflow(this.documentOverflow);
  }
  render() {
    return (h(Host, { tabindex: '-1' }, h("div", { class: "dialog-overlay", onClick: (evt) => this.onClose(evt) }, h("div", { class: "dialog confirmation-dialog" }, h("div", { class: "dialog-header" }, h("h3", { class: "dialog-title" }, this.config.title), h("button", { class: "close-button icon-close", onClick: (evt) => this.onClose(evt) })), h("div", { class: "dialog-body", innerHTML: this.config.message }), h("div", { class: "dialog-footer" }, h("button", { class: "cancel-button", onClick: (evt) => this.onClose(evt), ref: (el) => (this.cancelButton = el) }, this.translationService.translate('confirmation.btn.cancel.label')), h("button", { class: "confirm-button", onClick: (evt) => this.onConfirm(evt) }, this.translationService.translate('confirmation.btn.confirm.label')))))));
  }
  static get is() { return "confirmation-dialog"; }
  static get originalStyleUrls() {
    return {
      "$": ["confirmation-dialog.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["confirmation-dialog.css"]
    };
  }
  static get properties() {
    return {
      "translationService": {
        "type": "unknown",
        "mutable": false,
        "complexType": {
          "original": "TranslationService",
          "resolved": "TranslationService",
          "references": {
            "TranslationService": {
              "location": "import",
              "path": "../../services/translation.service"
            }
          }
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        }
      },
      "config": {
        "type": "unknown",
        "mutable": false,
        "complexType": {
          "original": "ConfirmationDialogConfig",
          "resolved": "{ title: string; message: string; }",
          "references": {
            "ConfirmationDialogConfig": {
              "location": "local"
            }
          }
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "defaultValue": "{\n    title: 'Confirmation',\n    message: 'Confirming?'\n  }"
      }
    };
  }
  static get events() {
    return [{
        "method": "internalConfirmationRejectedEvent",
        "name": "internalConfirmationRejectedEvent",
        "bubbles": true,
        "cancelable": true,
        "composed": true,
        "docs": {
          "tags": [],
          "text": "Event fired when confirmation is rejected and the dialog should be closed."
        },
        "complexType": {
          "original": "any",
          "resolved": "any",
          "references": {}
        }
      }, {
        "method": "internalConfirmationApprovedEvent",
        "name": "internalConfirmationApprovedEvent",
        "bubbles": true,
        "cancelable": true,
        "composed": true,
        "docs": {
          "tags": [],
          "text": "Event fired when confirmation is rejected and the dialog should be closed."
        },
        "complexType": {
          "original": "any",
          "resolved": "any",
          "references": {}
        }
      }];
  }
  static get elementRef() { return "hostElement"; }
  static get listeners() {
    return [{
        "name": "keydown",
        "method": "keydownListener",
        "target": "window",
        "capture": false,
        "passive": false
      }];
  }
}
