import { h } from '@stencil/core';
import { TranslationService } from "../../services/translation.service";
export class CopyLinkDialog {
  constructor() {
    this.config = undefined;
    this.serviceFactory = undefined;
    this.copyLinkEventsObserver = undefined;
    this.classes = undefined;
  }
  buildDialogConfig() {
    return {
      dialogTitle: this.config.dialogTitle || this.translationService.translate('yasqe.share.copy_link.dialog.title'),
      onClose: this.onClose.bind(this)
    };
  }
  onCopy(evt) {
    evt.stopPropagation();
    this.copyToClipboard().then(() => {
      if (this.copyLinkEventsObserver) {
        this.copyLinkEventsObserver.onLinkCopied();
      }
    });
  }
  onClose(evt) {
    const target = evt.target;
    evt.stopPropagation();
    const isOverlay = target.classList.contains('dialog-overlay');
    const isCloseButton = target.classList.contains('close-button');
    const isCancelButton = target.classList.contains('cancel-button');
    if (isOverlay || isCloseButton || isCancelButton) {
      if (this.copyLinkEventsObserver) {
        this.copyLinkEventsObserver.onDialogClosed();
      }
    }
  }
  componentWillLoad() {
    this.translationService = this.serviceFactory.get(TranslationService);
  }
  componentDidLoad() {
    // If not placed inside a setTimeout, the shareLink input is not selected for some reason.
    setTimeout(() => {
      this.shareLink.select();
    }, 100);
  }
  static fallbackCopyTextToClipboard(text) {
    const textArea = document.createElement("textarea");
    textArea.value = text;
    // Avoid scrolling to bottom
    textArea.style.top = "0";
    textArea.style.left = "0";
    textArea.style.position = "fixed";
    document.body.appendChild(textArea);
    textArea.focus();
    textArea.select();
    try {
      document.execCommand('copy');
    }
    catch (err) {
      console.error('Unable to copy', err);
    }
    document.body.removeChild(textArea);
  }
  copyToClipboard() {
    if (!navigator.clipboard) {
      CopyLinkDialog.fallbackCopyTextToClipboard(this.config.copyLink);
      return Promise.resolve();
    }
    return navigator.clipboard.writeText(this.config.copyLink).then(() => {
      // do nothing
    }, (err) => {
      console.error('Could not copy share link: ', err);
    });
  }
  render() {
    const classList = `copy-link-dialog ${this.classes}`;
    return (h("ontotext-dialog-web-component", { class: classList, config: this.buildDialogConfig() }, h("div", { slot: "body" }, h("div", { class: "copy-link-form" }, h("div", { class: "form-field copy-link-field" }, h("input", { type: "text", name: "shareLink", readonly: true, ref: (el) => (this.shareLink = el), value: this.config.copyLink })))), h("div", { slot: "footer" }, h("button", { class: "secondary-button cancel-button", onClick: (evt) => this.onClose(evt) }, this.translationService.translate('confirmation.btn.cancel.label')), h("button", { class: "primary-button copy-button", onClick: (evt) => this.onCopy(evt) }, this.translationService.translate('yasqe.share.copy_link.dialog.copy.btn.label')))));
  }
  static get is() { return "copy-link-dialog"; }
  static get originalStyleUrls() {
    return {
      "$": ["copy-link-dialog.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["copy-link-dialog.css"]
    };
  }
  static get properties() {
    return {
      "config": {
        "type": "unknown",
        "mutable": false,
        "complexType": {
          "original": "CopyLinkDialogConfig",
          "resolved": "{ dialogTitle?: string; copyLink: string; }",
          "references": {
            "CopyLinkDialogConfig": {
              "location": "local"
            }
          }
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        }
      },
      "serviceFactory": {
        "type": "unknown",
        "mutable": false,
        "complexType": {
          "original": "ServiceFactory",
          "resolved": "ServiceFactory",
          "references": {
            "ServiceFactory": {
              "location": "import",
              "path": "../../services/service-factory"
            }
          }
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        }
      },
      "copyLinkEventsObserver": {
        "type": "unknown",
        "mutable": false,
        "complexType": {
          "original": "CopyLinkObserver",
          "resolved": "CopyLinkObserver",
          "references": {
            "CopyLinkObserver": {
              "location": "local"
            }
          }
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        }
      },
      "classes": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "attribute": "classes",
        "reflect": false
      }
    };
  }
  static get elementRef() { return "hostElement"; }
}
