import { h, Host } from '@stencil/core';
import { EventService } from '../../services/event-service';
import { InternalEventType } from '../../models/internal-events/internal-event-types';
export class CopyResourceLinkButton {
  constructor() {
    this.uri = undefined;
    this.classes = undefined;
  }
  onButtonClick() {
    EventService.emitFromInnerElement(this.hostElement, InternalEventType.INTERNAL_SHOW_RESOURCE_COPY_LINK_DIALOG_EVENT, { copyLink: this.uri });
  }
  render() {
    const classList = `copy-resource-link-button ${this.classes || ''}`;
    return (h(Host, { class: classList }, h("a", { class: "icon-link", href: "#", onClick: () => this.onButtonClick() })));
  }
  static get is() { return "copy-resource-link-button"; }
  static get originalStyleUrls() {
    return {
      "$": ["copy-resource-link-button.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["copy-resource-link-button.css"]
    };
  }
  static get properties() {
    return {
      "uri": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "attribute": "uri",
        "reflect": false
      },
      "classes": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "attribute": "classes",
        "reflect": false
      }
    };
  }
  static get elementRef() { return "hostElement"; }
}
