import { h } from '@stencil/core';
export class CopyResourceLinkDialog {
  constructor() {
    this.serviceFactory = undefined;
    this.resourceLink = undefined;
  }
  onDialogClosed() {
    this.internalResourceLinkDialogClosedEvent.emit();
  }
  onLinkCopied() {
    this.internalResourceLinkCopiedEvent.emit();
  }
  render() {
    return (h("copy-link-dialog", { config: { copyLink: this.resourceLink }, classes: "copy-resource-link-dialog", serviceFactory: this.serviceFactory, copyLinkEventsObserver: this }));
  }
  static get is() { return "copy-resource-link-dialog"; }
  static get originalStyleUrls() {
    return {
      "$": ["copy-resource-link-dialog.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["copy-resource-link-dialog.css"]
    };
  }
  static get properties() {
    return {
      "serviceFactory": {
        "type": "unknown",
        "mutable": false,
        "complexType": {
          "original": "ServiceFactory",
          "resolved": "ServiceFactory",
          "references": {
            "ServiceFactory": {
              "location": "import",
              "path": "../../services/service-factory"
            }
          }
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        }
      },
      "resourceLink": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "attribute": "resource-link",
        "reflect": false
      }
    };
  }
  static get events() {
    return [{
        "method": "internalResourceLinkDialogClosedEvent",
        "name": "internalResourceLinkDialogClosedEvent",
        "bubbles": true,
        "cancelable": true,
        "composed": true,
        "docs": {
          "tags": [],
          "text": "Event fired when the dialog is closed by triggering one of the close controls, e.g. close or\ncancel button as well as clicking outside the dialog."
        },
        "complexType": {
          "original": "any",
          "resolved": "any",
          "references": {}
        }
      }, {
        "method": "internalResourceLinkCopiedEvent",
        "name": "internalResourceLinkCopiedEvent",
        "bubbles": true,
        "cancelable": true,
        "composed": true,
        "docs": {
          "tags": [],
          "text": "Internal event fired when resource link is copied to the clipboard."
        },
        "complexType": {
          "original": "any",
          "resolved": "any",
          "references": {}
        }
      }];
  }
}
