import { h } from '@stencil/core';
import { InternalDownloadAsEvent } from '../../models/internal-events/internal-download-as-event';
export class DownloadAs {
  constructor() {
    this.translationService = undefined;
    this.nameLabelKey = undefined;
    this.tooltipLabelKey = undefined;
    this.items = undefined;
    this.pluginName = undefined;
    this.query = undefined;
    this.infer = undefined;
    this.sameAs = undefined;
  }
  onInternalDropdownValueSelected(event) {
    this.downloadAs.emit(new InternalDownloadAsEvent(event.detail.payload.value, this.pluginName, this.query, this.infer, this.sameAs));
  }
  render() {
    return (h("ontotext-dropdown", { class: 'ontotext-download-as', onValueChanged: ev => this.onInternalDropdownValueSelected(ev), translationService: this.translationService, tooltipLabelKey: this.tooltipLabelKey, nameLabelKey: this.nameLabelKey ? this.nameLabelKey : DownloadAs.DEFAULT_NAME_LABEL, iconClass: 'icon-download', items: this.items }));
  }
  static get is() { return "ontotext-download-as"; }
  static get originalStyleUrls() {
    return {
      "$": ["download-as.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["download-as.css"]
    };
  }
  static get properties() {
    return {
      "translationService": {
        "type": "unknown",
        "mutable": false,
        "complexType": {
          "original": "TranslationService",
          "resolved": "TranslationService",
          "references": {
            "TranslationService": {
              "location": "import",
              "path": "../../services/translation.service"
            }
          }
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        }
      },
      "nameLabelKey": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "attribute": "name-label-key",
        "reflect": false
      },
      "tooltipLabelKey": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "attribute": "tooltip-label-key",
        "reflect": false
      },
      "items": {
        "type": "unknown",
        "mutable": false,
        "complexType": {
          "original": "DropdownOption[]",
          "resolved": "DropdownOption[]",
          "references": {
            "DropdownOption": {
              "location": "import",
              "path": "../../models/dropdown-option"
            }
          }
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        }
      },
      "pluginName": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "attribute": "plugin-name",
        "reflect": false
      },
      "query": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "attribute": "query",
        "reflect": false
      },
      "infer": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "attribute": "infer",
        "reflect": false
      },
      "sameAs": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "attribute": "same-as",
        "reflect": false
      }
    };
  }
  static get events() {
    return [{
        "method": "downloadAs",
        "name": "internalDownloadAsEvent",
        "bubbles": true,
        "cancelable": true,
        "composed": true,
        "docs": {
          "tags": [],
          "text": ""
        },
        "complexType": {
          "original": "InternalDownloadAsEvent",
          "resolved": "InternalDownloadAsEvent",
          "references": {
            "InternalDownloadAsEvent": {
              "location": "import",
              "path": "../../models/internal-events/internal-download-as-event"
            }
          }
        }
      }];
  }
}
DownloadAs.DEFAULT_NAME_LABEL = 'yasr.plugin_control.download_results.btn.label';
