import { h } from '@stencil/core';
import { InternalDropdownValueSelectedEvent } from '../../models/internal-events/internal-dropdown-value-selected-event';
export class Dropdown {
  constructor() {
    this.open = false;
    this.showTooltip = false;
    this.translationService = undefined;
    this.nameLabelKey = undefined;
    this.tooltipLabelKey = undefined;
    this.items = undefined;
    this.iconClass = '';
  }
  /**
   * Handles the Escape key keydown event and closes the dialog.
   * @param ev The keyboard event.
   */
  keydownListener(ev) {
    if (ev.key === 'Escape') {
      this.closeMenu();
    }
  }
  /**
   * Handles the mouse click events and closes the menu when target is outside the menu.
   * @param ev The mouse event.
   */
  mouseClickListener(ev) {
    const target = ev.target;
    if (!target.closest('.ontotext-dropdown')) {
      this.closeMenu();
    }
  }
  render() {
    const showToolbar = this.tooltipLabelKey && window.innerWidth < 768;
    const dropdownButtonClass = `ontotext-dropdown-button ${this.open ? 'icon-caret-up-after' : ' icon-caret-down-after'}
    ${this.iconClass ? `ontotext-dropdown-icon ${this.iconClass}` : ''}`;
    return (h("yasgui-tooltip", { "data-tooltip": showToolbar ? this.translate(this.nameLabelKey) : '' }, h("div", { class: 'ontotext-dropdown' }, h("button", { class: dropdownButtonClass, onClick: () => this.toggleComponent() }, h("span", { class: 'button-name' }, this.translate(this.nameLabelKey))), h("div", { class: `ontotext-dropdown-menu ${this.open ? 'open' : 'closed'}` }, this.items && this.items.map(item => h("a", { href: "#", class: 'ontotext-dropdown-menu-item', onClick: () => this.onSelect(item.value) }, this.translate(item.labelKey)))))));
  }
  onSelect(value) {
    this.open = false;
    this.valueChanged.emit(new InternalDropdownValueSelectedEvent(value));
  }
  toggleComponent() {
    this.open = !this.open;
  }
  translate(labelKey) {
    if (this.translationService) {
      return this.translationService.translate(labelKey);
    }
    return '';
  }
  closeMenu() {
    this.open = false;
  }
  static get is() { return "ontotext-dropdown"; }
  static get originalStyleUrls() {
    return {
      "$": ["dropdown.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["dropdown.css"]
    };
  }
  static get properties() {
    return {
      "translationService": {
        "type": "unknown",
        "mutable": false,
        "complexType": {
          "original": "TranslationService",
          "resolved": "TranslationService",
          "references": {
            "TranslationService": {
              "location": "import",
              "path": "../../services/translation.service"
            }
          }
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        }
      },
      "nameLabelKey": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "attribute": "name-label-key",
        "reflect": false
      },
      "tooltipLabelKey": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "attribute": "tooltip-label-key",
        "reflect": false
      },
      "items": {
        "type": "unknown",
        "mutable": false,
        "complexType": {
          "original": "DropdownOption[]",
          "resolved": "DropdownOption[]",
          "references": {
            "DropdownOption": {
              "location": "import",
              "path": "../../models/dropdown-option"
            }
          }
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        }
      },
      "iconClass": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "attribute": "icon-class",
        "reflect": false,
        "defaultValue": "''"
      }
    };
  }
  static get states() {
    return {
      "open": {},
      "showTooltip": {}
    };
  }
  static get events() {
    return [{
        "method": "valueChanged",
        "name": "valueChanged",
        "bubbles": true,
        "cancelable": true,
        "composed": true,
        "docs": {
          "tags": [],
          "text": ""
        },
        "complexType": {
          "original": "InternalDropdownValueSelectedEvent",
          "resolved": "InternalDropdownValueSelectedEvent",
          "references": {
            "InternalDropdownValueSelectedEvent": {
              "location": "import",
              "path": "../../models/internal-events/internal-dropdown-value-selected-event"
            }
          }
        }
      }];
  }
  static get listeners() {
    return [{
        "name": "keydown",
        "method": "keydownListener",
        "target": "window",
        "capture": false,
        "passive": false
      }, {
        "name": "click",
        "method": "mouseClickListener",
        "target": "window",
        "capture": false,
        "passive": false
      }];
  }
}
