import { h, Host } from '@stencil/core';
export class KeyboardShortcutsDialog {
  constructor() {
    this.open = undefined;
    this.items = [];
    this.translationService = undefined;
  }
  /**
   * Handles the Escape key keydown event and closes the dialog.
   * @param ev The keyboard event.
   */
  keydownListener(ev) {
    if (ev.key === 'Escape') {
      this.open = false;
    }
  }
  openDialog() {
    this.open = true;
  }
  closeDialog(evt) {
    const target = evt.target;
    evt.stopPropagation();
    if (target.classList.contains('close-button') || target.classList.contains('dialog-overlay')) {
      this.open = false;
    }
  }
  buildDialogConfig() {
    return {
      dialogTitle: this.translationService.translate('yasqe.keyboard_shortcuts.dialog.title'),
      onClose: this.closeDialog.bind(this)
    };
  }
  translateLabel(keyboardShortcutName) {
    return this.translate(`yasqe.keyboard_shortcuts.dialog.item.${keyboardShortcutName}.label`);
  }
  translateDescription(keyboardShortcutName) {
    return this.translate(`yasqe.keyboard_shortcuts.dialog.item.${keyboardShortcutName}.description`);
  }
  translate(labelKey) {
    if (this.translationService) {
      return this.translationService.translate(labelKey);
    }
    return labelKey;
  }
  render() {
    return (h(Host, { class: 'keyboard-shortcuts-dialog-wrapper' }, this.open &&
      h("ontotext-dialog-web-component", { config: this.buildDialogConfig() }, h("div", { slot: "body" }, this.items.map(keyboardShortcutDescriptionLabelKey => h("div", { class: 'keyboard-shortcut-description-item' }, h("kbd", { class: 'keyboard-shortcut-description-item-label' }, h("span", null, this.translateLabel(keyboardShortcutDescriptionLabelKey))), h("div", { class: 'keyboard-shortcut-description-item-description' }, this.translateDescription(keyboardShortcutDescriptionLabelKey)))))), !this.open && h("button", { class: 'keyboard-shortcuts-dialog-button', onClick: () => this.openDialog() }, this.translate('yasqe.keyboard_shortcuts.btn.label'))));
  }
  static get is() { return "keyboard-shortcuts-dialog"; }
  static get originalStyleUrls() {
    return {
      "$": ["keyboard-shortcuts-dialog.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["keyboard-shortcuts-dialog.css"]
    };
  }
  static get properties() {
    return {
      "items": {
        "type": "unknown",
        "mutable": false,
        "complexType": {
          "original": "string[]",
          "resolved": "string[]",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "defaultValue": "[]"
      },
      "translationService": {
        "type": "unknown",
        "mutable": false,
        "complexType": {
          "original": "TranslationService",
          "resolved": "TranslationService",
          "references": {
            "TranslationService": {
              "location": "import",
              "path": "../../services/translation.service"
            }
          }
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        }
      }
    };
  }
  static get states() {
    return {
      "open": {}
    };
  }
  static get listeners() {
    return [{
        "name": "keydown",
        "method": "keydownListener",
        "target": "window",
        "capture": false,
        "passive": false
      }];
  }
}
