import { Host, h } from '@stencil/core';
import { SvgUtil } from '../../services/utils/svg-util';
export class LoaderComponent {
  constructor() {
    this.timeFormattingService = undefined;
    this.showQueryProgress = false;
    this.message = undefined;
    this.additionalMessage = '';
    this.size = undefined;
    this.hidden = undefined;
    this.queryProgress = '';
  }
  startInterval() {
    this.updateState();
  }
  updateState() {
    if (this.hidden) {
      this.clearLoader();
      this.hostElement.classList.add('hidden');
    }
    else {
      this.hostElement.classList.remove('hidden');
      if (this.showQueryProgress && !this.updateLoaderInterval) {
        this.queryProgress = '';
        this.startTime = Date.now();
        this.updateLoaderMessage();
        this.updateLoaderInterval = setInterval(() => {
          this.updateLoaderMessage();
        }, 1000);
      }
    }
  }
  updateLoaderMessage() {
    if (this.showQueryProgress) {
      const durationTime = (Date.now() - this.startTime);
      const durationTimeInSeconds = durationTime / 1000;
      if (durationTimeInSeconds > 10) {
        this.queryProgress = LoaderComponent.EMPTY_QUERY_PROGRESS + this.timeFormattingService.getHumanReadableSeconds(durationTime);
      }
    }
    else {
      this.clearLoader();
    }
  }
  componentDidLoad() {
    // As documentation said "The @Watch() decorator does not fire when a component initially loads."
    // yasgui instance will not be created if we set configuration when component is loaded, which
    // will be most case of the component usage. So we call the method manually when component is
    // loaded. More info https://github.com/TriplyDB/Yasgui/issues/143
    this.updateState();
  }
  disconnectedCallback() {
    this.clearLoader();
  }
  clearLoader() {
    if (this.updateLoaderInterval) {
      clearInterval(this.updateLoaderInterval);
      this.updateLoaderInterval = null;
    }
    this.queryProgress = '';
  }
  render() {
    return (h(Host, { class: 'ontotext-yasgui-loader hidden' }, h("slot", null, !this.hidden &&
      h("div", { class: 'loader-component' }, h("div", { innerHTML: SvgUtil.getLoaderSvgTag(this.size) }), h("div", null, this.message, " ", this.queryProgress), h("div", null, this.additionalMessage)))));
  }
  static get is() { return "loader-component"; }
  static get encapsulation() { return "shadow"; }
  static get originalStyleUrls() {
    return {
      "$": ["loader-component.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["loader-component.css"]
    };
  }
  static get properties() {
    return {
      "timeFormattingService": {
        "type": "unknown",
        "mutable": false,
        "complexType": {
          "original": "TimeFormattingService",
          "resolved": "TimeFormattingService",
          "references": {
            "TimeFormattingService": {
              "location": "import",
              "path": "../../services/utils/time-formatting-service"
            }
          }
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        }
      },
      "showQueryProgress": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "attribute": "show-query-progress",
        "reflect": false,
        "defaultValue": "false"
      },
      "message": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "attribute": "message",
        "reflect": false
      },
      "additionalMessage": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "attribute": "additional-message",
        "reflect": false,
        "defaultValue": "''"
      },
      "size": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "attribute": "size",
        "reflect": false
      },
      "hidden": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": ""
        },
        "attribute": "hidden",
        "reflect": false
      }
    };
  }
  static get states() {
    return {
      "queryProgress": {}
    };
  }
  static get elementRef() { return "hostElement"; }
  static get watchers() {
    return [{
        "propName": "hidden",
        "methodName": "startInterval"
      }];
  }
}
LoaderComponent.EMPTY_QUERY_PROGRESS = '... ';
